/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.utils.SpringContextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CallBackTimeOutCheckCmd {
    private static final Log log = LogFactory.getLog(CallBackTimeOutCheckCmd.class);
    public static final String TASK_NAME = "esp:callback_check2";
    private final IFullAsyncRequestGateway fullAsyncRequestGateway;
    private final ILockGateway lockGateway;

    public CallBackTimeOutCheckCmd(IFullAsyncRequestGateway fullAsyncRequestGateway, ILockGateway lockGateway) {
        this.fullAsyncRequestGateway = fullAsyncRequestGateway;
        this.lockGateway = lockGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=60000L)
    public void doTask() {
        if (!this.lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 120)) {
            log.info((Object)"task is running");
            return;
        }
        try {
            log.info((Object)"callback time out check task start");
            Date end = new Date();
            Date start = DateUtils.addDays((Date)end, (int)-1);
            List callBackList = this.fullAsyncRequestGateway.getTimeOutFullAsyncRequestInfo(start, end);
            if (CollectionUtils.isEmpty((Collection)callBackList)) {
                log.info((Object)"callback time out check is no data");
                return;
            }
            callBackList.forEach(one -> {
                try {
                    this.fullAsyncRequestGateway.alarmCallbackTimeOut(one);
                    this.fullAsyncRequestGateway.saveTimeOutCheckTag(one.getReqId());
                }
                catch (Exception e) {
                    log.error((Object)("send callback timeout info error\uff0creqId: " + one.getReqId()), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"callback check err", (Throwable)e);
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
        }
    }

    public static class CallBackCheckRunable
    implements Runnable,
    Serializable {
        @Override
        public void run() {
            CallBackTimeOutCheckCmd cmd = (CallBackTimeOutCheckCmd)SpringContextUtil.getBean(CallBackTimeOutCheckCmd.class);
            if (cmd != null) {
                cmd.doTask();
            }
        }
    }
}

