/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.CallbackConvertor;
import com.digiwin.cross.app.dto.request.CallbackRequest;
import com.digiwin.cross.app.dto.response.CallBackResponse;
import com.digiwin.cross.domain.bo.CallResponseBO;
import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.convertor.InvokeConvertor;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.ServiceCallbackReqidNotFoundException;
import com.digiwin.cross.domain.exception.ServiceCallbackReqidProcessedException;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.service.impl.CallBackService;
import com.digiwin.cross.domain.utils.CallBackLogUtil;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class CallbackCmd {
    private static final Log log = LogFactory.getLog(CallbackCmd.class);
    private final CallBackService callBackService;
    private final IFullAsyncRequestGateway fullAsyncRequestGateway;
    private final ILockGateway lockGateway;

    public CallbackCmd(CallBackService callBackService, IFullAsyncRequestGateway fullAsyncRequestGateway, ILockGateway lockGateway) {
        this.callBackService = callBackService;
        this.fullAsyncRequestGateway = fullAsyncRequestGateway;
        this.lockGateway = lockGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallBackResponse execute(CallbackRequest request) throws BaseException {
        CallBackResponse callBackResponse;
        block6: {
            String reqId = (String)request.getHeaders().get("digi-reqid");
            boolean locked = false;
            try {
                if (!this.lockGateway.tryLock(LockNamespaceEnum.EAI_FULLASYNC_REQID, reqId, 0, 130)) {
                    throw new ServiceCallbackReqidProcessedException();
                }
                log.info((Object)String.format("Service callback ReqId: %s is locked", reqId));
                locked = true;
                FullAsyncRequestBO context = this.fullAsyncRequestGateway.getFullAsyncRequestInfo(reqId, 6, TimeUnit.SECONDS.toMillis(5L));
                if (null == context) {
                    throw new ServiceCallbackReqidNotFoundException();
                }
                this.fullAsyncRequestGateway.setCallBackTag(reqId);
                CallBackLogUtil.beforeCallBackRequester((String)request.getRestUrl(), (FullAsyncRequestBO)context, (Map)request.getHeaders(), (String)request.getBody());
                ServiceResponseBO serviceResponseBO = InvokeConvertor.convertToServiceResponseBO((ResponseBO)request);
                CallResponseBO rs = this.callBackService.call(context, serviceResponseBO);
                if (rs.isBusinessSuccess()) {
                    this.fullAsyncRequestGateway.removeFullAsyncRequestInfo(serviceResponseBO.getReqId());
                }
                callBackResponse = CallbackConvertor.convertRs(rs);
                if (!locked) break block6;
            }
            catch (Throwable throwable) {
                if (locked) {
                    log.info((Object)String.format("Service callback ReqId: %s is unlocked", reqId));
                    this.lockGateway.unlock(LockNamespaceEnum.EAI_FULLASYNC_REQID, reqId);
                }
                throw throwable;
            }
            log.info((Object)String.format("Service callback ReqId: %s is unlocked", reqId));
            this.lockGateway.unlock(LockNamespaceEnum.EAI_FULLASYNC_REQID, reqId);
        }
        return callBackResponse;
    }
}

