/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.QueryEaiLogsConverter;
import com.digiwin.cross.app.dto.QueryEaiLogsResultDTO;
import com.digiwin.cross.app.dto.request.QueryEaiLogsRequest;
import com.digiwin.cross.app.dto.response.QueryEaiLogsResponse;
import com.digiwin.cross.app.exception.EaiErrorException;
import com.digiwin.cross.app.exception.EaiNotRespondException;
import com.digiwin.cross.app.exception.EaiVersionNotSupportException;
import com.digiwin.cross.app.exception.QueryEaiLogsException;
import com.digiwin.cross.app.exception.ReqIdNotFoundInEaiException;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.gateway.IEaiGateway;
import com.digiwin.cross.domain.utils.Base64Util;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.mq.po.EaiResponse;
import com.digiwin.cross.infrastructure.mq.po.EaiResult;
import com.digiwin.cross.infrastructure.mq.po.MqMessage;
import com.digiwin.cross.infrastructure.mq.po.MqResult;
import com.digiwin.cross.infrastructure.mq.po.RestResponse;
import com.digiwin.queue.saas.SaasClient;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class QueryEaiLogsCmd {
    private static final Log log = LogFactory.getLog(QueryEaiLogsCmd.class);
    private SaasClient mqClient;
    private IEaiGateway eaiGateway;

    public QueryEaiLogsCmd(SaasClient maClient, IEaiGateway eaiGateway) {
        this.mqClient = maClient;
        this.eaiGateway = eaiGateway;
    }

    public QueryEaiLogsResponse queryEaiLogs(QueryEaiLogsRequest request) throws Exception {
        try {
            EaiEntity eaiEntity = this.eaiGateway.getEaiByTenantId(request.getTenantId());
            if (eaiEntity == null) {
                return QueryEaiLogsResponse.builder().code(9).description("TenantId not found").build();
            }
            MqMessage tMqMessage = QueryEaiLogsConverter.convertToMqMessage(request.getReqId());
            ArrayBlockingQueue tResultQueue = new ArrayBlockingQueue(1);
            ArrayBlockingQueue tResponseQueue = new ArrayBlockingQueue(1);
            SaasClient.CompleteCallback tCompleteCallback = pMessage -> {
                log.info((Object)"Eai logs MQ return");
                MqResult tMqResult = (MqResult)JsonUtil.toJavaObj((String)pMessage, MqResult.class);
                EaiResult tEaiResult = (EaiResult)tMqResult.getDetail().get(0);
                tResultQueue.offer(tEaiResult.getResult());
                tResponseQueue.offer(tEaiResult.getResponse());
            };
            SaasClient.TimeoutCallback tTimeoutCallback = pMessage -> {
                log.info((Object)"Eai logs MQ timeout");
                tResultQueue.offer(false);
                tResponseQueue.offer("timeout");
            };
            this.mqClient.onSend(eaiEntity.getLongConnId(), eaiEntity.getGatewayId(), JsonUtil.toJson((Object)tMqMessage), tCompleteCallback, tTimeoutCallback, Integer.valueOf(20), TimeUnit.SECONDS);
            Boolean tResult = (Boolean)tResultQueue.take();
            String tMqResponse = (String)tResponseQueue.take();
            if (!tResult.booleanValue()) {
                if ("timeout".equals(tMqResponse)) {
                    throw new EaiNotRespondException();
                }
                throw new EaiErrorException(tMqResponse);
            }
            EaiResponse tEaiResponse = (EaiResponse)JsonUtil.toJavaObj((String)tMqResponse, EaiResponse.class);
            String tRestMessage = Base64Util.decodeString((String)tEaiResponse.getMessage(), (String)StandardCharsets.UTF_8.name());
            RestResponse tEaiRestResponse = (RestResponse)JsonUtil.toJavaObj((String)tRestMessage, RestResponse.class);
            String tDigiCode = (String)tEaiRestResponse.getHeaders().get("digi-code");
            if ("101".equals(tDigiCode)) {
                throw new EaiVersionNotSupportException();
            }
            QueryEaiLogsResultDTO tQueryResult = (QueryEaiLogsResultDTO)JsonUtil.toJavaObj((String)tEaiRestResponse.getMessagebody(), QueryEaiLogsResultDTO.class);
            if (!tQueryResult.getResult().booleanValue()) {
                throw new EaiErrorException(tQueryResult.getMessage());
            }
            if (CollectionUtils.isEmpty(tQueryResult.getLogs())) {
                throw new ReqIdNotFoundInEaiException();
            }
            return QueryEaiLogsResponse.builder().code(0).logs(tQueryResult.getLogs().stream().map(QueryEaiLogsConverter::convertToEaiLogDTO).collect(Collectors.toList())).build();
        }
        catch (QueryEaiLogsException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return QueryEaiLogsResponse.builder().code(e.getCode()).description(e.getMessage()).build();
        }
    }
}

