/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.StateCodeSolutionConverter;
import com.digiwin.cross.app.dto.StateCodeSolutionDTO;
import com.digiwin.cross.app.dto.request.QuerySolutionRequest;
import com.digiwin.cross.domain.gateway.IStateCodeSolutionGateway;
import com.digiwin.cross.infrastructure.gatewayimpl.StateCodeSolutionGateway;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class QuerySolutionCmd {
    private IStateCodeSolutionGateway stateCodeSolutionGateway;

    public QuerySolutionCmd(StateCodeSolutionGateway stateCodeSolutionGateway) {
        this.stateCodeSolutionGateway = stateCodeSolutionGateway;
    }

    public List<StateCodeSolutionDTO> querySolution(QuerySolutionRequest request) {
        if (CollectionUtils.isNotEmpty(request.getStateCode())) {
            List tEntityList = this.stateCodeSolutionGateway.querySolutionListByStateCodes(request.getStateCode());
            return tEntityList.stream().map(stateCodeSolutionEntity -> StateCodeSolutionConverter.convertToStateCodeSolutionDTO(stateCodeSolutionEntity, request.getReqAp(), request.getResAp(), request.getServiceName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

