/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.ProductDTO;
import com.digiwin.cross.app.dto.UnionProductDTO;
import com.digiwin.cross.app.dto.request.GetProdRequest;
import com.digiwin.cross.app.dto.request.ProductRegisterRequest;
import com.digiwin.cross.app.dto.request.ProductSrvRegisterRequest;
import com.digiwin.cross.app.dto.response.EaiRegisterResponse;
import com.digiwin.cross.app.dto.response.GetProdResponse;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProductBOConvertor {
    public static ProductEntity convertToProductBO(ProductRegisterRequest request) {
        ProductRegisterRequest.Host host = request.getHost();
        ProductEntity productBO = new ProductEntity();
        productBO.setUid(host.getUid());
        productBO.setName(host.getProd());
        productBO.setApid(host.getId());
        productBO.setTimezone(host.getTimezone());
        productBO.setVersion(host.getVer());
        productBO.setIpAddress(host.getIp());
        productBO.setRestUrl(host.getResturl());
        productBO.setRetryTimes(NumberUtils.createLong((String)host.getRetrytimes()));
        productBO.setRetryInterval(NumberUtils.createLong((String)host.getRetryinterval()));
        productBO.setConcurrence(NumberUtils.createLong((String)host.getConcurrence()));
        productBO.setClientOnly(host.getClientonly());
        productBO.setSettingEocFlag(Boolean.valueOf(true));
        productBO.setAppId(request.getHost().getAppId());
        productBO.setSettingEocFlag(request.getHost().getSettingEocFlag());
        return productBO;
    }

    public static ProductEntity convertToProductBO(ProductSrvRegisterRequest request) {
        ProductSrvRegisterRequest.Host host = request.getHost();
        ProductEntity productBO = new ProductEntity();
        productBO.setUid(host.getUid());
        productBO.setName(host.getProd());
        productBO.setApid(host.getId());
        productBO.setTimezone(host.getTimezone());
        productBO.setVersion(host.getVer());
        productBO.setIpAddress(host.getIp());
        productBO.setRestUrl(host.getResturl());
        productBO.setRetryTimes(NumberUtils.createLong((String)host.getRetrytimes()));
        productBO.setRetryInterval(NumberUtils.createLong((String)host.getRetryinterval()));
        productBO.setConcurrence(NumberUtils.createLong((String)host.getConcurrence()));
        productBO.setClientOnly(Boolean.valueOf(false));
        productBO.setAppId(request.getAppId());
        productBO.setSettingEocFlag(host.getSettingEocFlag());
        return productBO;
    }

    public static ProductEntity convertToProductBO(GetProdRequest request) {
        GetProdRequest.Host host = request.getHost();
        ProductEntity productBO = new ProductEntity();
        productBO.setName(host.getProd());
        productBO.setApid(host.getId());
        productBO.setVersion(host.getVer());
        productBO.setIpAddress(host.getIp());
        productBO.setUid(host.getUid());
        return productBO;
    }

    public static EaiRegisterResponse.EspProduct convertToEaiRegProductDTO(ProductEntity bo) {
        EaiRegisterResponse.EspProduct dto = new EaiRegisterResponse.EspProduct();
        dto.setVer(bo.getVersion());
        dto.setUid(bo.getUid());
        dto.setName(bo.getName());
        dto.setIp(bo.getIpAddress());
        dto.setId(bo.getApid());
        dto.setVer(bo.getVersion());
        dto.setIsdefault(BooleanUtils.isTrue((Boolean)bo.getIsDefault()));
        dto.setResturl(bo.getRestUrl());
        return dto;
    }

    public static List<ProductDTO> convertToProductDto(List<ProductEntity> bos) {
        if (null == bos) {
            return null;
        }
        return bos.stream().map(one -> ProductBOConvertor.convertToProductDto(one)).collect(Collectors.toList());
    }

    public static List<UnionProductDTO> convertToUnionProductDto(List<ProductEntity> bos) {
        if (null == bos) {
            return null;
        }
        return bos.stream().map(one -> ProductBOConvertor.convertToUnionProductDto(one)).collect(Collectors.toList());
    }

    public static List<GetProdResponse.ProductInfo> convertToGetProdResInfo(List<ProductEntity> bos) {
        if (null == bos) {
            return null;
        }
        return bos.stream().map(one -> ProductBOConvertor.convertToGetProdResInfo(one)).collect(Collectors.toList());
    }

    public static ProductDTO convertToProductDto(ProductEntity bo) {
        ProductDTO productDTO = new ProductDTO();
        ProductBOConvertor.fillProductDto(productDTO, bo);
        if (null == productDTO.getResturl()) {
            productDTO.setResturl("");
        }
        return productDTO;
    }

    public static UnionProductDTO convertToUnionProductDto(ProductEntity bo) {
        UnionProductDTO productDTO = new UnionProductDTO();
        ProductBOConvertor.fillUnionProductDto(productDTO, bo);
        if (null == productDTO.getResturl()) {
            productDTO.setResturl("");
        }
        return productDTO;
    }

    public static GetProdResponse.ProductInfo convertToGetProdResInfo(ProductEntity bo) {
        GetProdResponse.ProductInfo productInfo = new GetProdResponse.ProductInfo();
        ProductBOConvertor.fillProductDto(productInfo, bo);
        productInfo.setConcurrence(bo.getConcurrence());
        productInfo.setRetryinterval(bo.getRetryInterval());
        productInfo.setRetrytimes(bo.getRetryTimes());
        productInfo.setTimezone(bo.getTimezone());
        return productInfo;
    }

    public static List<EaiRegisterResponse.EspProduct> convertToEaiRegProductDTO(List<ProductEntity> bos) {
        if (null == bos) {
            return null;
        }
        return bos.stream().map(one -> ProductBOConvertor.convertToEaiRegProductDTO(one)).collect(Collectors.toList());
    }

    private static void fillProductDto(ProductDTO dto, ProductEntity bo) {
        dto.setId(bo.getApid());
        dto.setIp(bo.getIpAddress());
        dto.setName(bo.getName());
        dto.setResturl(bo.getRestUrl());
        dto.setUid(bo.getUid());
        dto.setVer(bo.getVersion());
    }

    private static void fillUnionProductDto(UnionProductDTO dto, ProductEntity bo) {
        dto.setId(bo.getId());
        dto.setApId(bo.getApid());
        dto.setIp(bo.getIpAddress());
        dto.setName(bo.getName());
        dto.setResturl(bo.getRestUrl());
        dto.setUid(bo.getUid());
        dto.setVer(bo.getVersion());
    }
}

