/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEaiInfoConvertor {
    private static final Log log = LogFactory.getLog(QueryEaiInfoConvertor.class);

    public static EaiDTO convertToEaiDTO(UnionEAIPO unionEAIPO) {
        if (unionEAIPO != null) {
            EaiDTO eaiDTO = new EaiDTO();
            eaiDTO.setUid(unionEAIPO.getUid());
            eaiDTO.setIp(unionEAIPO.getIpAddress());
            eaiDTO.setTenant_id(unionEAIPO.getLongConnId());
            eaiDTO.setGateway_id(unionEAIPO.getGatewayId());
            return eaiDTO;
        }
        return null;
    }

    public static List<String> couvertToTenantIdList(List<EaiTenantMappingPO> eaiTenantMappingPOList) {
        if (CollectionUtils.isNotEmpty(eaiTenantMappingPOList)) {
            return eaiTenantMappingPOList.stream().map(EaiTenantMappingPO::getTenantId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

