package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.SaveDapLogConvertor;
import com.digiwin.cross.app.dto.request.SaveDapLogRequest;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.infrastructure.gatewayimpl.LogGateway;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description:
 * @author: clay
 * @date: 2023/7/19
 */
@Component
public class SaveDapLogCmd {

    private LogGateway logGateway;

    public SaveDapLogCmd(LogGateway logGateway) {
        this.logGateway = logGateway;
    }

    public void saveDapLogs(List<SaveDapLogRequest> requestList) throws Exception {
        for (SaveDapLogRequest saveDapLogRequest : requestList) {
            List<LogBO> tLogBOList = SaveDapLogConvertor.convertToLogBOList(saveDapLogRequest);
            logGateway.writeLogs(tLogBOList);
        }

    }
}
