package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2024/8/6
 */
@CommonsLog
public class QueryEaiInfoConvertor {
    public static EaiDTO convertToEaiDTO(UnionEAIPO unionEAIPO) {
        if(unionEAIPO != null) {
            EaiDTO eaiDTO = new EaiDTO();
            eaiDTO.setUid(unionEAIPO.getUid());
            eaiDTO.setIp(unionEAIPO.getIpAddress());
//            eaiDTO.setRemark(unionEAIPO.getRemark());
            eaiDTO.setTenant_id(unionEAIPO.getLongConnId());
//            eaiDTO.setGateway_name(unionEAIPO.getGatewayName());
            eaiDTO.setGateway_id(unionEAIPO.getGatewayId());

            return eaiDTO;
        } else {
            return null;
        }
    }

    public static List<String> couvertToTenantIdList(List<EaiTenantMappingPO> eaiTenantMappingPOList) {
        if(CollectionUtils.isNotEmpty(eaiTenantMappingPOList)) {
            return eaiTenantMappingPOList.stream().map(EaiTenantMappingPO::getTenantId).collect(Collectors.toList());
        } else {
            return Collections.emptyList();
        }
    }
}
