package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.StateCodeSolutionDTO;
import com.digiwin.cross.domain.bo.entity.StateCodeSolutionEntity;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2023/12/5
 */
public class StateCodeSolutionConverter {

    public static StateCodeSolutionDTO convertToStateCodeSolutionDTO(StateCodeSolutionEntity stateCodeSolutionEntity, String reqAp, String resAp, String service) {

        StateCodeSolutionDTO tStateCodeSolutionDTO = new StateCodeSolutionDTO();

        tStateCodeSolutionDTO.setStateCode(stateCodeSolutionEntity.getStateCode());

        tStateCodeSolutionDTO.setSolutionZhTW(
                stateCodeSolutionEntity.getSolutionZhTW().stream()
                        .map(s -> replaceSolutionContent(s, reqAp, resAp, service))
                        .collect(Collectors.toList())
        );
        tStateCodeSolutionDTO.setSolutionZhCN(
                stateCodeSolutionEntity.getSolutionZhCN().stream()
                        .map(s -> replaceSolutionContent(s, reqAp, resAp, service))
                        .collect(Collectors.toList())
        );
        tStateCodeSolutionDTO.setSolutionEN(
                stateCodeSolutionEntity.getSolutionEN().stream()
                        .map(s -> replaceSolutionContent(s, reqAp, resAp, service))
                        .collect(Collectors.toList())
        );

        return tStateCodeSolutionDTO;
    }

    private static String replaceSolutionContent(String content, String reqAp, String resAp, String serviceName) {

        if (StringUtils.isNotEmpty(reqAp)) {
            String[] tReqAp = reqAp.split("/");
            content = content.replaceAll("\\[服務請求方\\]", tReqAp[0]);
            content = content.replaceAll("\\[服务请求方\\]", tReqAp[0]);
            content = content.replaceAll("\\[service requester\\]", tReqAp[0]);
        }
        if (StringUtils.isNotEmpty(resAp)) {
            String[] tResAp = resAp.split("/");
            content = content.replaceAll("\\[服務提供方\\]", tResAp[0]);
            content = content.replaceAll("\\[服务提供方\\]", tResAp[0]);
            content = content.replaceAll("\\[service provider\\]", tResAp[0]);
        }
        if (StringUtils.isNotEmpty(serviceName)) {
            content = content.replaceAll("\\[服務名稱\\]", serviceName);
            content = content.replaceAll("\\[服务名称\\]", serviceName);
            content = content.replaceAll("\\[service name\\]", serviceName);
        }
        return content;
    }
}
