package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/5 14:27
 */
@Getter
@Setter
public class ErrorResponse extends BaseResponse {

    @JsonProperty("Called operation")
    private String operation;

    private Object error;

    public ErrorResponse(BaseException e, String operation) {
        this.operation = operation;
        super.setState(e.getStateEnum());
        error = JsonUtil.toObjectWhenIsJson(e.getMessage());
    }
}
