package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/8/28 16:29
 */
@CommonsLog
@Component
public class SyncMdcAllCmd {

    public final static String TASK_NAME = "sync_mdc_task";

    private final ILockGateway lockGateway;

    private final ISyncMdcGateway syncMdcGateway;

    private final EspRedisService espRedisService;

    public SyncMdcAllCmd (ILockGateway lockGateway, ISyncMdcGateway syncMdcGateway, EspRedisService espRedisService) {
        this.lockGateway = lockGateway;
        this.syncMdcGateway = syncMdcGateway;
        this.espRedisService = espRedisService;
    }

    @Scheduled(fixedDelay = 5 * 60 * 1000)
    public void doTask () {
        if (!lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 120)) {
            log.info("task is running");
            return;
        }
        try {
            if (espRedisService.remove(CacheKeyEnum.ESP_MDC_ERR_FLAG, "ERROR_FLAG") != null) {
                log.warn("有同步MDC失败，开始补偿");
                syncMdcGateway.syncAllProduct();
            } else {
                log.warn("无同步MDC失败");
            }
        } finally {
            lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
        }
    }
}
