package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.EaiLogDTO;
import com.digiwin.cross.app.dto.QueryEaiLog;
import com.digiwin.cross.domain.utils.Base64Util;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.mq.po.MqMessage;
import com.digiwin.cross.infrastructure.mq.po.RestRequest;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.seata.compressor.gzip.GzipUtil;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;

/**
 * @author clay
 * on 2023/12/8
 */
@CommonsLog
public class QueryEaiLogsConverter {

    private static final String EAI_LOGS_OPERATION = "getUnionLog";
    private static final String ENTRY_TYPE = "RESTFUL";
    private static final String KEY_REQID = "reqid";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    public static MqMessage convertToMqMessage(String reqId) {
        MqMessage tMqMessage = new MqMessage();
        tMqMessage.setOperation(EAI_LOGS_OPERATION);
        tMqMessage.setReqId(reqId);
        tMqMessage.setEntryType(ENTRY_TYPE);

        RestRequest tRestRequest = new RestRequest();
        tRestRequest.setPathParam("");
        tRestRequest.setQueryParam("");
        tRestRequest.setHeaders(Collections.emptyMap());
        ObjectNode tReqRestMessageJo = JsonUtil.createJsonObject();
        tReqRestMessageJo.put(KEY_REQID, reqId);
        tRestRequest.setMessagebody(JsonUtil.toJson(tReqRestMessageJo));


        String tMessage = null;
        try {
            tMessage = Base64Util.encodeString(JsonUtil.toJson(tRestRequest), StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        tMqMessage.setMessage(tMessage);

        return tMqMessage;
    }

    public static EaiLogDTO convertToEaiLogDTO(QueryEaiLog eaiLog) {
        SimpleDateFormat tDataFormat = new SimpleDateFormat(DATE_FORMAT);
        String logMessage = "";
        Long tPlatformTime = null;
        Long tStandardTime = null;

        try {
            if (StringUtils.isNotEmpty(eaiLog.getLogMessage())) {
                logMessage = Base64Util.decodeString(eaiLog.getLogMessage());
            }

            tPlatformTime = tDataFormat.parse(eaiLog.getPlatformTime()).getTime();
            tStandardTime = tDataFormat.parse(eaiLog.getStandardTime()).getTime();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return EaiLogDTO.builder()
                .reqId(eaiLog.getReqId())
                .stateCode(eaiLog.getStateCode())
                .requestAp(eaiLog.getRequestAp())
                .requestApVersion(eaiLog.getRequestApVersion())
                .requestApIp(eaiLog.getRequestApIp())
                .requestApId(eaiLog.getRequestApId())
                .requestApUid(eaiLog.getRequestApUid())
                .requestApUser(eaiLog.getRequestApUser())
                .requestTimestamp(eaiLog.getRequestTimestamp())
                .serviceAp(eaiLog.getServiceAp())
                .serviceName(eaiLog.getServiceName())
                .serviceDescription(eaiLog.getServiceDescription())
                .serviceVersion(eaiLog.getServiceVersion())
                .messageSize(eaiLog.getMessageSize())
                .platformTime(tPlatformTime)
                .standardTime(tStandardTime)
                .dataKey(eaiLog.getDataKey())
                .operation(eaiLog.getOperation())
                .msgFormat(eaiLog.getMsgFormat())
                .unionApIp(eaiLog.getUnionApIp())
                .logDisplayPriority(eaiLog.getLogDisplayPriority())
                .tenantId(eaiLog.getTenantId())
                .compressedMessage(GzipUtil.compress(logMessage.getBytes()))
                .build();
    }
}
