package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.request.SaveDapLogRequest;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.common.OperationConstant;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.GZipUtil;
import com.digiwin.cross.domain.utils.LogUtil;
import com.digiwin.cross.domain.utils.StringUtil;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * @description:
 * @author: clay
 * @date: 2023/7/19
 */
public class SaveDapLogConvertor {
    public static List<LogBO> convertToLogBOList(SaveDapLogRequest request) throws IOException {
        SaveDapLogRequest.RequestInfo tRequest = request.getRequest();
        RequesterInfoBO tRequesterInfo = new RequesterInfoBO();
        tRequesterInfo.setProd(tRequest.getApName());
        tRequesterInfo.setVer(tRequest.getVersion());
        tRequesterInfo.setIp(tRequest.getIp());
        tRequesterInfo.setId(tRequest.getId());
        tRequesterInfo.setUid(tRequest.getUid());
        tRequesterInfo.setAcct(tRequest.getApUser());
        tRequesterInfo.setTimestamp(tRequest.getTimestamp());

        SaveDapLogRequest.ServiceInfo tService = request.getService();
        ProviderInfoBO tProviderInfo = new ProviderInfoBO();
        tProviderInfo.setProd(tService.getApName());
        tProviderInfo.setVer(tService.getVersion());
        tProviderInfo.setIp(tService.getIp());
        tProviderInfo.setId(tService.getId());
        tProviderInfo.setUid(tService.getUid());
        tProviderInfo.setName(tService.getServiceName());
        tProviderInfo.setTenantId(tService.getTenantId());

        List<LogBO> tLogBOList = new ArrayList<>();
        for (SaveDapLogRequest.LogEntry logEntry : request.getLogs()) {
            LogBO tLogBO = new LogBO();
            tLogBO.setReqId(request.getReq_id());
            tLogBO.setRequesterBO(tRequesterInfo);
            tLogBO.setProviderBO(tProviderInfo);
            tLogBO.setStateEnum(StateEnum.STATEENUM_CODE_MAP.get(logEntry.getStateCode()));
            tLogBO.setLogDisplayPriority(logEntry.getLogDisplayPriority());
            tLogBO.setReqDataKey(logEntry.getDataKey());
            tLogBO.setOperation(OperationConstant.SAVE_DAP_LOGS);
            tLogBO.setMsgType(LogBO.MessageFormat.JSON);

            String tHttpLine = null;
            if (StringUtils.isNotBlank(logEntry.getUrl())) {
                tHttpLine = "POST " + logEntry.getUrl();
            }
            String tBody = "";
            if (StringUtils.isNotBlank(logEntry.getBody())) {
                tBody = GZipUtil.decompress(logEntry.getBody());
            }
            tLogBO.setMessage(LogUtil.convertRestLogMessage(tHttpLine, logEntry.getHeaders(), tBody, request.getPtxId()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(tBody));

            Calendar tPlatformTime = Calendar.getInstance();
            tPlatformTime.setTimeInMillis(logEntry.getPlatformTime());
            tLogBO.setPlatformTime(tPlatformTime);
            tLogBO.setPinpointId(request.getPtxId());
            tLogBOList.add(tLogBO);
        }

        return tLogBOList;
    }
}
