package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.response.InvokeResponse;
import com.digiwin.cross.domain.bo.ServiceResponseBO;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/26
 */
public class ServiceResponseBOConvertor {

    public static InvokeResponse convertToInvokeResponse(ServiceResponseBO pServiceResponseBO, Map<String, String> pCallbackHeaders) {
        InvokeResponse tInvokeResponse = new InvokeResponse();

        //有重複的以服務端回傳的優先，所以先放callbackHeader再放ResponseHeader
        Map<String, String> tHeaders = new HashMap<>();
        pCallbackHeaders.forEach((headerName, headerValue) -> tHeaders.put(headerName,headerValue));
        pServiceResponseBO.getHeaders().forEach((headerName, headerValue) -> tHeaders.put(headerName,headerValue));

        tInvokeResponse.setHeaders(tHeaders);
        tInvokeResponse.setBody(pServiceResponseBO.getBody());

        return tInvokeResponse;
    }
}
