package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.app.dto.EaiProdDTO;
import com.digiwin.cross.domain.bo.entity.EaiTenantEntity;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/12 15:48
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class EaiRegisterResponse extends BaseResponse {

    private String action;

    private EaiDTO host;

    private List<EaiProdDTO> prod;

    private List<EaiTenantEntity> existsEaiTenants;

    public EaiRegisterResponse(String action, EaiDTO host, List<EspProduct> prod, StateEnum state) {
        this.action = action;
        this.host = host;
        if (prod != null) {
            this.prod = new ArrayList<>();
            this.prod.addAll(prod);
        }
        super.setState(state);
    }

    public EaiRegisterResponse(List<EaiProdDTO> prods, StateEnum state) {
        this.prod = prods;
        super.setState(state);
    }

    public EaiRegisterResponse(StateEnum state, List<EaiTenantEntity> existsEaiTenants) {
        this.existsEaiTenants = existsEaiTenants;
        super.setState(state);
    }

    @Getter
    @Setter
    public static class EspProduct extends EaiProdDTO {

        private String resturl;

        private Boolean isdefault;

    }
}
