package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.ProductDTO;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/7/19 10:04
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class GetProdResponse extends BaseResponse {

    private List<ProductInfo> prod;

    public GetProdResponse(StateEnum stateEnum, List<ProductInfo> prods) {
        super.setState(stateEnum);
        this.prod = prods;
    }

    @Getter
    @Setter
    public static class ProductInfo extends ProductDTO {

        private String timezone;

        private Long concurrence;

        private Long retrytimes;

        private Long retryinterval;
    }
}
