/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.ProductBOConvertor;
import com.digiwin.cross.app.dto.request.ProductRegisterRequest;
import com.digiwin.cross.app.dto.response.ProductRegisterResponse;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.ClientOnlyProductCannotBeModifiedException;
import com.digiwin.cross.domain.exception.InvokeRestFormatValidationException;
import com.digiwin.cross.domain.exception.ProductExistException;
import com.digiwin.cross.domain.exception.ProductNotFoundException;
import com.digiwin.cross.domain.exception.RESTParseException;
import com.digiwin.cross.domain.exception.UnionProductExistException;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.domain.service.IProductService;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.infrastructure.http.HttpUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductRegisterCmd {
    private final IProductService productService;
    private final HttpUtil httpUtil;
    private final ILockGateway lockGateway;
    private final ISyncMdcGateway syncMdcGateway;

    public ProductRegisterCmd(IProductService productService, HttpUtil httpUtil, ILockGateway lockGateway, ISyncMdcGateway syncMdcGateway) {
        this.productService = productService;
        this.httpUtil = httpUtil;
        this.lockGateway = lockGateway;
        this.syncMdcGateway = syncMdcGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductRegisterResponse registerProduct(ProductRegisterRequest request) throws BaseException {
        this.lockGateway.tryLock(LockNamespaceEnum.REG_PROD, request.getHost().getProd(), 100);
        try {
            boolean checkUrlRs;
            ProductRegisterRequest.Host host = request.getHost();
            boolean existsProduct = this.productService.validExistsProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
            if (existsProduct) {
                throw new ProductExistException();
            }
            existsProduct = this.productService.validExistsUnionProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
            if (existsProduct) {
                throw new UnionProductExistException();
            }
            if (BooleanUtils.isNotTrue((Boolean)host.getClientonly()) && !(checkUrlRs = this.httpUtil.checkRestURL(host.getResturl()))) {
                throw new RESTParseException();
            }
            ProductEntity productBO = ProductBOConvertor.convertToProductBO(request);
            this.productService.saveProductBO(productBO);
            ProductRegisterResponse productRegisterResponse = new ProductRegisterResponse(productBO.getUid(), StateEnum.REGPROD_REGED);
            return productRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_PROD, request.getHost().getProd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductRegisterResponse updateProduct(ProductRegisterRequest request) throws BaseException {
        this.lockGateway.tryLock(LockNamespaceEnum.REG_PROD, request.getHost().getProd(), 100);
        try {
            boolean checkUrlRs;
            ProductRegisterRequest.Host host = request.getHost();
            if (StringUtils.isBlank((CharSequence)host.getUid())) {
                throw new InvokeRestFormatValidationException("uid is null");
            }
            ProductEntity productEntity = this.productService.findProduct(host.getUid(), null, null, null);
            if (null == productEntity) {
                throw new ProductNotFoundException();
            }
            if (BooleanUtils.isTrue((Boolean)productEntity.getClientOnly()) || BooleanUtils.isTrue((Boolean)host.getClientonly())) {
                throw new ClientOnlyProductCannotBeModifiedException();
            }
            boolean existsProduct = this.productService.validExistsOtherProduct(host.getProd(), host.getIp(), host.getId(), productEntity.getId());
            if (existsProduct) {
                throw new ProductExistException();
            }
            existsProduct = this.productService.validExistsUnionProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
            if (existsProduct) {
                throw new UnionProductExistException();
            }
            if (BooleanUtils.isNotTrue((Boolean)host.getClientonly()) && !(checkUrlRs = this.httpUtil.checkRestURL(host.getResturl()))) {
                throw new RESTParseException();
            }
            ProductEntity productBO = ProductBOConvertor.convertToProductBO(request);
            productBO.setId(productEntity.getId());
            if (productBO.getAppId() == null) {
                productBO.setAppId(productEntity.getAppId());
            }
            if (productBO.getSettingEocFlag() == null) {
                productBO.setSettingEocFlag(productEntity.getSettingEocFlag());
            }
            ProductEntity newProduct = this.productService.updateProductBO(productBO);
            this.syncMdcGateway.addFailFlag();
            ProductRegisterResponse productRegisterResponse = new ProductRegisterResponse(productBO.getUid(), StateEnum.REGPROD_UPDED);
            return productRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_PROD, request.getHost().getProd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductRegisterResponse unRegisterProduct(ProductRegisterRequest request) throws BaseException {
        this.lockGateway.tryLock(LockNamespaceEnum.REG_PROD, request.getHost().getProd(), 100);
        try {
            ProductRegisterRequest.Host host = request.getHost();
            if (StringUtils.isBlank((CharSequence)host.getUid())) {
                throw new InvokeRestFormatValidationException("uid is null");
            }
            ProductEntity productEntity = this.productService.deleteProduct(host.getUid());
            if (null == productEntity) {
                ProductRegisterResponse productRegisterResponse = new ProductRegisterResponse(null, StateEnum.REGPROD_DELED);
                return productRegisterResponse;
            }
            this.syncMdcGateway.addFailFlag();
            ProductRegisterResponse productRegisterResponse = new ProductRegisterResponse(productEntity.getUid(), StateEnum.REGPROD_DELED);
            return productRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_PROD, request.getHost().getProd());
        }
    }
}

