/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.ProductBOConvertor;
import com.digiwin.cross.app.convertor.ServiceBOConvertor;
import com.digiwin.cross.app.dto.request.ProductSrvRegisterRequest;
import com.digiwin.cross.app.dto.response.ProductSrvRegisterResponse;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.RESTParseException;
import com.digiwin.cross.domain.exception.UnionProductExistException;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.domain.service.IProductService;
import com.digiwin.cross.domain.service.ISrvService;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.infrastructure.http.HttpUtil;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ProductSrvRegisterCmd {
    private static final Log log = LogFactory.getLog(ProductSrvRegisterCmd.class);
    private static final String SRV_NAME_REGEX = "^[a-zA-Z0-9_\\-,\\./]{1,100}($|;([a-zA-Z0-9._-]{1,20}$)|;(|[a-zA-Z0-9._-]{1,20});([\\-\u4e00-\u9fa5_a-zA-Z0-9]{1,100}$))";
    private static final String SRV_NAME_ERR_FORMAT = "Service register info is invalid. [%s]";
    private final IProductService productService;
    private final ISrvService srvService;
    private final HttpUtil httpUtil;
    private final ILockGateway lockGateway;
    private final ISyncMdcGateway syncMdcGateway;

    public ProductSrvRegisterCmd(IProductService productService, ISrvService srvService, HttpUtil httpUtil, ILockGateway lockGateway, ISyncMdcGateway syncMdcGateway) {
        this.productService = productService;
        this.srvService = srvService;
        this.httpUtil = httpUtil;
        this.lockGateway = lockGateway;
        this.syncMdcGateway = syncMdcGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductSrvRegisterResponse register(ProductSrvRegisterRequest request) throws BaseException {
        this.lockGateway.tryLock(LockNamespaceEnum.REG_PROD, request.getHost().getProd(), 100);
        try {
            ProductSrvRegisterResponse productSrvRegisterResponse;
            ProductSrvRegisterRequest.Host host = request.getHost();
            boolean existsUnionProduct = this.productService.validExistsUnionProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
            if (existsUnionProduct) {
                throw new UnionProductExistException();
            }
            boolean checkUrlRs = this.httpUtil.checkRestURL(host.getResturl());
            if (!checkUrlRs) {
                throw new RESTParseException();
            }
            ProductEntity productBO = ProductBOConvertor.convertToProductBO(request);
            ProductEntity existsProduct = this.productService.findExistsProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
            if (existsProduct == null) {
                this.productService.saveProductBO(productBO);
            } else {
                productBO.setId(existsProduct.getId());
                productBO.setUid(existsProduct.getUid());
                this.productService.updateProductBO(productBO);
            }
            String uid = productBO.getUid();
            ArrayList<String> regFailSrvs = new ArrayList<String>();
            ArrayList<String> successSrvs = new ArrayList<String>();
            ArrayList srvs = new ArrayList();
            request.getService().getSrvname().forEach(srvName -> {
                if (!srvName.matches(SRV_NAME_REGEX)) {
                    log.error((Object)String.format(SRV_NAME_ERR_FORMAT, srvName));
                    regFailSrvs.add((String)srvName);
                } else {
                    srvs.add(srvName);
                }
            });
            this.lockGateway.tryLock(LockNamespaceEnum.REG_SERVICE, productBO.getId().toString(), 100);
            ArrayList successSrvBOS = new ArrayList();
            try {
                srvs.forEach(one -> {
                    ServiceEntity srvBO = ServiceBOConvertor.convertToServiceBO(productBO, one);
                    boolean success = this.srvService.regService(productBO, srvBO);
                    if (success) {
                        successSrvs.add((String)one);
                        successSrvBOS.add(srvBO);
                    } else {
                        regFailSrvs.add((String)one);
                    }
                });
            }
            finally {
                this.lockGateway.unlock(LockNamespaceEnum.REG_SERVICE, productBO.getId().toString());
            }
            if (!successSrvBOS.isEmpty()) {
                ProductBO tProductBO = new ProductBO(productBO, successSrvBOS);
                this.syncMdcGateway.addProduct(tProductBO);
                this.srvService.checkDuplicate(successSrvBOS);
            }
            if (CollectionUtils.isNotEmpty(regFailSrvs)) {
                productSrvRegisterResponse = new ProductSrvRegisterResponse(uid, successSrvs, regFailSrvs, StateEnum.REG_SRV_ONE_MORE_FAILED);
                return productSrvRegisterResponse;
            }
            productSrvRegisterResponse = new ProductSrvRegisterResponse(uid, successSrvs, regFailSrvs, StateEnum.REGPROD_REGED);
            return productSrvRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_PROD, request.getHost().getProd());
        }
    }
}

