/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.app.convertor.QueryEaiInfoConvertor;
import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.app.dto.response.QueryEaiInfoResponse;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryEaiInfoCmd {
    private static final Log log = LogFactory.getLog(QueryEaiInfoCmd.class);
    private final UnionEaiMapper unionEaiMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;

    @Autowired
    public QueryEaiInfoCmd(UnionEaiMapper unionEaiMapper, EaiTenantMappingMapper eaiTenantMappingMapper) {
        this.unionEaiMapper = unionEaiMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
    }

    public QueryEaiInfoResponse execute(String tenantId) {
        EaiTenantMappingPO eaiTenantMappingPO = (EaiTenantMappingPO)this.eaiTenantMappingMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getTenantId, (Object)tenantId));
        if (eaiTenantMappingPO != null) {
            String eaiUid = eaiTenantMappingPO.getEaiUid();
            EaiDTO eaiDTO = null;
            List<String> tenantIdList = null;
            UnionEAIPO unionEAIPO = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)eaiUid));
            if (unionEAIPO != null) {
                List eaiTenantMappingPOList = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getEaiUid, (Object)eaiUid));
                eaiDTO = QueryEaiInfoConvertor.convertToEaiDTO(unionEAIPO);
                tenantIdList = QueryEaiInfoConvertor.couvertToTenantIdList(eaiTenantMappingPOList);
                QueryEaiInfoResponse response = new QueryEaiInfoResponse();
                response.setEaiDTO(eaiDTO);
                response.setTenantIdList(tenantIdList);
                return response;
            }
            return null;
        }
        return null;
    }
}

