/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.ServiceBOConvertor;
import com.digiwin.cross.app.dto.request.SrvRegisterRequest;
import com.digiwin.cross.app.dto.response.SrvRegisterResponse;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.ClientOnlyProductCannotBeModifiedException;
import com.digiwin.cross.domain.exception.ProductNotFoundException;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.domain.service.IProductService;
import com.digiwin.cross.domain.service.ISrvService;
import com.digiwin.cross.domain.state.StateEnum;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class SrvRegisterCmd {
    private static final Log log = LogFactory.getLog(SrvRegisterCmd.class);
    private String SRV_NAME_REGEX = "^[a-zA-Z0-9_\\-,\\./]{1,100}($|;([a-zA-Z0-9._-]{1,20}$)|;(|[a-zA-Z0-9._-]{1,20});([\\-\u4e00-\u9fa5_a-zA-Z0-9]{1,100}$))";
    private String SRV_NAME_ERR_FORMAT = "Service register info is invalid. [%s]";
    private final IProductService productService;
    private final ISrvService srvService;
    private final ISyncMdcGateway syncMdcGateway;
    private final ILockGateway lockGateway;

    public SrvRegisterCmd(IProductService productService, ISrvService srvService, ISyncMdcGateway syncMdcGateway, ILockGateway lockGateway) {
        this.productService = productService;
        this.srvService = srvService;
        this.syncMdcGateway = syncMdcGateway;
        this.lockGateway = lockGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrvRegisterResponse registerSrv(SrvRegisterRequest request) throws BaseException {
        SrvRegisterRequest.Host host = request.getHost();
        ProductEntity product = this.productService.findProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
        if (null == product) {
            throw new ProductNotFoundException();
        }
        if (BooleanUtils.isTrue((Boolean)product.getClientOnly())) {
            throw new ClientOnlyProductCannotBeModifiedException();
        }
        ArrayList<String> regFailSrvs = new ArrayList<String>();
        ArrayList<String> successSrvs = new ArrayList<String>();
        ArrayList srvs = new ArrayList();
        request.getService().getSrvname().forEach(srvName -> {
            if (!srvName.matches(this.SRV_NAME_REGEX)) {
                log.error((Object)String.format(this.SRV_NAME_ERR_FORMAT, srvName));
                regFailSrvs.add((String)srvName);
            } else {
                srvs.add(srvName);
            }
        });
        if (CollectionUtils.isEmpty(srvs)) {
            return new SrvRegisterResponse(new SrvRegisterResponse.Result(null, regFailSrvs), StateEnum.REG_SRV_ONE_MORE_FAILED);
        }
        log.info((Object)"\u5f00\u59cb\u6267\u884c\u6ce8\u518c\u670d\u52a1");
        this.lockGateway.tryLock(LockNamespaceEnum.REG_SERVICE, product.getId().toString(), 100);
        log.info((Object)"\u5f00\u59cb\u6267\u884c\u6ce8\u518c\u670d\u52a1-\u52a0\u9501\u6210\u529f");
        ArrayList successSrvBOS = new ArrayList();
        try {
            srvs.forEach(one -> {
                ServiceEntity srvBO = ServiceBOConvertor.convertToServiceBO(product, one);
                boolean success = this.srvService.regService(product, srvBO);
                if (success) {
                    successSrvs.add((String)one);
                    successSrvBOS.add(srvBO);
                } else {
                    regFailSrvs.add((String)one);
                }
            });
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_SERVICE, product.getId().toString());
        }
        if (!successSrvBOS.isEmpty()) {
            ProductBO tProductBO = new ProductBO(product, successSrvBOS);
            log.info((Object)"\u5f00\u59cb\u6267\u884c\u6ce8\u518c\u670d\u52a1-\u540c\u6b65MDC");
            this.syncMdcGateway.addProduct(tProductBO);
            log.info((Object)"\u5f00\u59cb\u6267\u884c\u6ce8\u518c\u670d\u52a1-\u68c0\u67e5\u91cd\u590d");
            this.srvService.checkDuplicate(successSrvBOS);
            log.info((Object)"\u5f00\u59cb\u6267\u884c\u6ce8\u518c\u670d\u52a1-\u68c0\u67e5\u91cd\u590d\u7ed3\u675f");
        }
        if (CollectionUtils.isNotEmpty(regFailSrvs)) {
            return new SrvRegisterResponse(new SrvRegisterResponse.Result(successSrvs, regFailSrvs), StateEnum.REG_SRV_ONE_MORE_FAILED);
        }
        return new SrvRegisterResponse(new SrvRegisterResponse.Result(successSrvs, null), StateEnum.REGSRV_REGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrvRegisterResponse unRegisterSrv(SrvRegisterRequest request) throws BaseException {
        SrvRegisterRequest.Host host = request.getHost();
        ProductEntity product = this.productService.findProduct(host.getUid(), host.getProd(), host.getIp(), host.getId());
        if (null == product) {
            throw new ProductNotFoundException();
        }
        if (BooleanUtils.isTrue((Boolean)product.getClientOnly())) {
            throw new ClientOnlyProductCannotBeModifiedException();
        }
        ArrayList<String> regFailSrvs = new ArrayList<String>();
        ArrayList<String> successSrvs = new ArrayList<String>();
        try {
            this.lockGateway.tryLock(LockNamespaceEnum.REG_SERVICE, product.getId().toString(), 100);
            request.getService().getSrvname().forEach(srvName -> {
                boolean success = this.srvService.unRegisterSrv(product, srvName);
                if (success) {
                    successSrvs.add((String)srvName);
                } else {
                    regFailSrvs.add((String)srvName);
                }
            });
            if (CollectionUtils.isNotEmpty(successSrvs)) {
                this.syncMdcGateway.addFailFlag();
            }
            if (CollectionUtils.isNotEmpty(regFailSrvs)) {
                SrvRegisterResponse srvRegisterResponse = new SrvRegisterResponse(new SrvRegisterResponse.Result(successSrvs, regFailSrvs), StateEnum.REG_SRV_ONE_MORE_FAILED);
                return srvRegisterResponse;
            }
            SrvRegisterResponse srvRegisterResponse = new SrvRegisterResponse(new SrvRegisterResponse.Result(successSrvs, null), StateEnum.REGSRV_REGED);
            return srvRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_SERVICE, product.getId().toString());
        }
    }
}

