/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.request.ConfigCallbackTimeoutRequest;
import com.digiwin.cross.app.dto.request.QueryCallbackTimeoutRequest;
import com.digiwin.cross.app.dto.response.QueryCallbackTimeoutResponse;
import com.digiwin.cross.domain.bo.CallbackTimeoutProductBO;
import com.digiwin.cross.domain.bo.CallbackTimeoutServiceBO;
import com.digiwin.cross.domain.bo.entity.CallbackTimeoutEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CallbackTimeoutConvertor {
    public static CallbackTimeoutEntity convertToCallbackTimeoutEntity(ConfigCallbackTimeoutRequest request) {
        CallbackTimeoutEntity entity = new CallbackTimeoutEntity();
        CallbackTimeoutProductBO tProductBO = new CallbackTimeoutProductBO();
        tProductBO.setProductName(request.getName());
        if (StringUtils.isNotBlank((CharSequence)request.getUid())) {
            tProductBO.setProductUid(request.getUid());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTenantId())) {
            tProductBO.setTenantId(request.getTenantId());
        }
        tProductBO.setTimeout(request.getTimeout());
        entity.setCallbackTImeoutProductBO(tProductBO);
        if (MapUtils.isNotEmpty(request.getService())) {
            List tServiceBOList = request.getService().entrySet().stream().map(stringLongEntry -> {
                CallbackTimeoutServiceBO tServiceBO = new CallbackTimeoutServiceBO();
                tServiceBO.setServiceName((String)stringLongEntry.getKey());
                tServiceBO.setTimeout((Integer)stringLongEntry.getValue());
                return tServiceBO;
            }).collect(Collectors.toList());
            entity.setCallbackTimeoutServiceBOList(tServiceBOList);
        }
        return entity;
    }

    public static CallbackTimeoutEntity convertToCallbackTimeoutEntity(QueryCallbackTimeoutRequest request) {
        CallbackTimeoutEntity entity = new CallbackTimeoutEntity();
        CallbackTimeoutProductBO tProductBO = new CallbackTimeoutProductBO();
        tProductBO.setProductName(request.getName());
        if (StringUtils.isNotBlank((CharSequence)request.getUid())) {
            tProductBO.setProductUid(request.getUid());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTenantId())) {
            tProductBO.setTenantId(request.getTenantId());
        }
        entity.setCallbackTImeoutProductBO(tProductBO);
        if (CollectionUtils.isNotEmpty(request.getService())) {
            List tServiceBOList = request.getService().stream().map(s -> {
                CallbackTimeoutServiceBO tServiceBO = new CallbackTimeoutServiceBO();
                tServiceBO.setServiceName(s);
                return tServiceBO;
            }).collect(Collectors.toList());
            entity.setCallbackTimeoutServiceBOList(tServiceBOList);
        }
        return entity;
    }

    public static QueryCallbackTimeoutResponse convertToQueryCallbackTimeoutResponse(CallbackTimeoutEntity entity) {
        QueryCallbackTimeoutResponse response = new QueryCallbackTimeoutResponse();
        if (null == entity) {
            return response;
        }
        if (entity.getCallbackTImeoutProductBO() != null) {
            response.setName(entity.getCallbackTImeoutProductBO().getProductName());
            response.setUid(entity.getCallbackTImeoutProductBO().getProductUid());
            response.setTenantId(entity.getCallbackTImeoutProductBO().getTenantId());
            response.setTimeout(entity.getCallbackTImeoutProductBO().getTimeout());
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getCallbackTimeoutServiceBOList())) {
            Map<String, Integer> serviceMap = entity.getCallbackTimeoutServiceBOList().stream().collect(Collectors.toMap(CallbackTimeoutServiceBO::getServiceName, CallbackTimeoutServiceBO::getTimeout));
            response.setService(serviceMap);
        }
        return response;
    }
}

