/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.app.dto.request.EaiRegisterRequest;
import com.digiwin.cross.domain.bo.EaiBO;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.EaiTenantEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceVersionEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EaiBOConvertor {
    public static EaiBO convertToBO(EaiRegisterRequest registerRequest) {
        EaiDTO eai = registerRequest.getEai();
        EaiEntity eaiEntity = new EaiEntity();
        eaiEntity.setGatewayId(eai.getGateway_id());
        eaiEntity.setGatewayName(eai.getGateway_name());
        eaiEntity.setIpAddress(eai.getIp());
        eaiEntity.setLongConnId(eai.getTenant_id());
        eaiEntity.setRemark(eai.getRemark());
        eaiEntity.setUid(eai.getUid());
        ArrayList tenantMappingBOS = Lists.newArrayList((Object[])new EaiTenantEntity[]{new EaiTenantEntity(eai.getTenant_id())});
        if (CollectionUtils.isNotEmpty(registerRequest.getTenant())) {
            HashMap<String, Integer> existsTenantMap = new HashMap<String, Integer>();
            existsTenantMap.put(eai.getTenant_id(), 1);
            registerRequest.getTenant().forEach(one -> {
                if (!existsTenantMap.containsKey(one)) {
                    tenantMappingBOS.add(new EaiTenantEntity(one, null, eaiEntity.getUid()));
                    existsTenantMap.put((String)one, 1);
                }
            });
        }
        ArrayList productBOS = new ArrayList();
        EaiBO eaiBO = new EaiBO(eaiEntity, (List)tenantMappingBOS, productBOS);
        registerRequest.getProd().forEach(product -> {
            ProductEntity productEntity = new ProductEntity();
            productEntity.setApid(product.getId());
            productEntity.setIpAddress(product.getIp());
            productEntity.setName(product.getName());
            productEntity.setUid(product.getUid());
            productEntity.setVersion(product.getVer());
            ProductBO productBO = new ProductBO(productEntity, null);
            productBOS.add(productBO);
            if (CollectionUtils.isEmpty(product.getServices())) {
                return;
            }
            productBO.setServices(product.getServices().stream().map(srv -> {
                ServiceEntity srvBO = new ServiceEntity();
                srvBO.setServiceName(srv.getName());
                if (StringUtils.isNotBlank((CharSequence)srv.getVersion())) {
                    srvBO.setVersion(new ServiceVersionEntity(srv.getVersion()));
                }
                return srvBO;
            }).collect(Collectors.toList()));
        });
        return eaiBO;
    }
}

