package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ILogGateway;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/8/28 16:29
 */
@CommonsLog
@Component
public class CleanLogCmd {

    public final static String TASK_NAME = "clean_log_task";

    private final ILogGateway logGateway;

    private final ILockGateway lockGateway;

    public CleanLogCmd (ILogGateway logGateway, ILockGateway lockGateway) {
        this.logGateway = logGateway;
        this.lockGateway = lockGateway;
    }

    @Scheduled(cron = "0 00 03 ? * *")
    public void doTask () {
        if (!lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 120)) {
            log.info("task is running");
            return;
        }
        try {
            logGateway.cleanExpiredLogs();
        } finally {
            lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
        }
    }
}
