package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.ServiceRequestBOConvertor;
import com.digiwin.cross.app.convertor.ServiceResponseBOConvertor;
import com.digiwin.cross.app.dto.request.InvokeRequest;
import com.digiwin.cross.app.dto.response.InvokeResponse;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.service.IInvokeService;
import com.digiwin.cross.domain.service.validator.ProductValidator;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.state.StateEnum;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class InvokeCmd {

    private ProductValidator productValidator;

    private IInvokeService invokeService;

    public InvokeCmd(ProductValidator productValidator, IInvokeService invokeService) {
        this.productValidator = productValidator;
        this.invokeService = invokeService;
    }

    public InvokeResponse execute(InvokeRequest pRequest) throws Exception {

        //驗證發起端
        RequesterBO tRequesterBO = productValidator.validateRequester(pRequest.getHostInfo());

        //驗證服務端
        ProviderBO tProviderBO = productValidator.validateProvider(pRequest.getServiceInfo());

        ServiceRequestBO tServiceRequestBO = ServiceRequestBOConvertor.convertToServiceRequestBO(pRequest, tRequesterBO, tProviderBO);
        ServiceResponseBO tServiceResponseBO = invokeService.execute(tServiceRequestBO);

        InvokeResponse tInvokeResponse = ServiceResponseBOConvertor.convertToInvokeResponse(tServiceResponseBO, tServiceRequestBO.getCallbackHeaders());
        switch (tServiceRequestBO.getRequestType()) {
            case SYNC:
                //若穩態EAI錯誤，使用原錯誤code
                if (BooleanUtils.isNotFalse(tServiceResponseBO.getEaiSuccess())) {
                    tInvokeResponse.setState(StateEnum.SYNC_MSG_RETURNED);
                } else {
                    tInvokeResponse.setState(StateEnum.STATEENUM_CODE_MAP.get(tServiceResponseBO.getCode()));
                }
                break;
            case FASYNC:
                //若穩態EAI錯誤，使用原錯誤code
                if (BooleanUtils.isNotFalse(tServiceResponseBO.getEaiSuccess())) {
                    if (tRequesterBO.isAgile()) {
                        tInvokeResponse.setState(StateEnum.FASYNC_MSG_RETURNED);
                    } else {
                        tInvokeResponse.setState(StateEnum.UNION_FASYNC_MSG_RETURNED);
                    }
                } else {
                    tInvokeResponse.setState(StateEnum.STATEENUM_CODE_MAP.get(tServiceResponseBO.getCode()));
                }
                break;
        }

        return tInvokeResponse;
    }

}
