package com.digiwin.cross.app.convertor;

import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceVersionEntity;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/8 16:14
 */
public class ServiceBOConvertor {

    public static ServiceEntity convertToServiceBO(ProductEntity productBO, String srvName) {
        ServiceEntity serviceBO = new ServiceEntity();
        serviceBO.setProductId(productBO.getId());
        serviceBO.setProdName(productBO.getName());
        String[] srvNameSplitArr = srvName.split(";");
        serviceBO.setServiceName(srvNameSplitArr[0]);
        if (srvNameSplitArr.length > 1) {
            serviceBO.setVersion(new ServiceVersionEntity(srvNameSplitArr[1]));
        }
        if (srvNameSplitArr.length > 2) {
            serviceBO.setServiceDescription(srvNameSplitArr[2]);
        }
        return serviceBO;
    }
}
