package com.digiwin.cross.app.convertor;

import com.digiwin.athena.esp.sdk.enums.TenantInfoEnum;
import com.digiwin.athena.esp.sdk.util.TenantInfoUtil;
import com.digiwin.cross.app.dto.Eocmap;
import com.digiwin.cross.app.dto.request.InvokeRequest;
import com.digiwin.cross.app.exception.LocalEaiInvokeTenantIdNotFoundException;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.IFilterHeaderService;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.utils.FilterHeaderUtil;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Map;
import java.util.Objects;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/20
 */
public class ServiceRequestBOConvertor implements ApplicationContextAware {

    private static IFilterHeaderService filterHeaderService;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        filterHeaderService = applicationContext.getBean(IFilterHeaderService.class);
    }

    public static ServiceRequestBO convertToServiceRequestBO(InvokeRequest pRequest, RequesterBO pRequesterBO, ProviderBO pProviderBO) throws BaseException {
        ServiceRequestBO tServiceRequest = new ServiceRequestBO();
        tServiceRequest.setReqId(pRequest.getReqId());
        tServiceRequest.setDispatchId(pRequest.getDispatchId());
        tServiceRequest.setPathParam(pRequest.getPathParam());
        tServiceRequest.setQueryParams(pRequest.getQueryParam());

        //取得callbackHeader
        Map<String, String> tCallbackHeaders = FilterHeaderUtil.callbackHeaders(pRequest.getHeaders());
        tServiceRequest.setCallbackHeaders(tCallbackHeaders);

        //透傳header
        Map<String, String> tPassHeaders = FilterHeaderUtil.passHeaders(pRequest.getHeaders());
        //header黑名單
        tPassHeaders = FilterHeaderUtil.filterBlockHeaders(tPassHeaders, pProviderBO.getProductType());

        final Eocmap tEocmap = new Eocmap();
        tPassHeaders.forEach((headerName, headerValue) -> {
            switch (headerName) {
                case HeaderNamesConstant.DIGI_REQID:
                case HeaderNamesConstant.DIGI_HOST:
                case HeaderNamesConstant.DIGI_SERVICE:
                case HeaderNamesConstant.DIGI_KEY:
                case HeaderNamesConstant.DISPATCHID:
                    break;
                case HeaderNamesConstant.DIGI_TYPE:
                    RequestType tRequestType = EnumUtils.getEnum(RequestType.class, headerValue.toUpperCase());
                    tServiceRequest.setRequestType(tRequestType);
                    break;
                case HeaderNamesConstant.DIGI_DATA_KEY:
                    tServiceRequest.setDataKey(headerValue);
                    break;
                case HeaderNamesConstant.DIGI_OMMAP:
                    if (StringUtils.isBlank(pRequest.getServiceInfo().getTenantId())) {
                        Map<String, String> tMap = null;
                        tEocmap.setExist(true);
                        try {
                            tMap = TenantInfoUtil.getTenantIdAndToken(pRequest.getHostInfo().getEaiUid(), pRequest.getHostInfo().getUid(), headerValue);
                            // 如果有成功取得租戶ID 則把租戶ID加到digi-service以及routerkey header中
                            if (tMap.get(TenantInfoEnum.TENANT_ID.toString()) != null) {
                                tEocmap.setTenantId(tMap.get(TenantInfoEnum.TENANT_ID.toString()));
                            }
                            // 如果有成功取得token 則把token加到http header"token"中
                            if (tMap.get(TenantInfoEnum.USER_TOKEN.toString()) != null) {
                                tEocmap.setToken(tMap.get(TenantInfoEnum.USER_TOKEN.toString()));
                            }

                            // 取得digi-eocmap 並放入digi-eocmap 標頭中
                            String eocMapString = TenantInfoUtil.getEocMap(tMap.get(TenantInfoEnum.TENANT_ID.toString()), pRequest.getHostInfo().getProd(), headerValue);
                            tEocmap.setEocmap(eocMapString);

                            // 先一律把exception都抓起來 EAI Response:找不到調用所屬租戶(狀態碼：286)
                        } catch (Exception e) {
                            tEocmap.setException(new LocalEaiInvokeTenantIdNotFoundException(e));

                        }
                    }
                    tServiceRequest.getDigiHeaders().put(headerName, headerValue);
                    break;
                default:
                    tServiceRequest.getDigiHeaders().put(headerName, headerValue);
                    break;
            }
        });

        //設定eocmap
        if (tEocmap.isExist()) {
            if (tEocmap.getException() != null) {
                throw tEocmap.getException();
            }
            if (tEocmap.getTenantId() != null) {
                pRequest.getServiceInfo().setTenantId(tEocmap.getTenantId());
                tServiceRequest.getDigiHeaders().put("routerKey", tEocmap.getTenantId());
            }
            if (tEocmap.getToken() != null) {
                tServiceRequest.getDigiHeaders().put("token", tEocmap.getToken());
            }
            if (tEocmap.getEocmap() != null) {
                tServiceRequest.getDigiHeaders().put("digi-eocmap", tEocmap.getEocmap());
            }
        }


        //host
        RequesterInfoBO tHostInfoBO = new RequesterInfoBO();
        BeanUtils.copyProperties(pRequest.getHostInfo(), tHostInfoBO);
        ProductEntity tHostProductBO = pRequesterBO.getProduct();
        if (tHostProductBO != null) {
            tHostInfoBO.setVer(tHostProductBO.getVersion());
            tHostInfoBO.setIp(Objects.toString(tHostProductBO.getIpAddress(), ""));
            tHostInfoBO.setId(tHostProductBO.getApid());
            tHostInfoBO.setUid(tHostProductBO.getUid());
        }
        if (pProviderBO.getProductType() == ProductType.STANDARD) {
            tHostInfoBO.setEaiUid(ApplicationSystemParameter.UNION_SYS_UID);
        }

        tServiceRequest.setHostInfo(tHostInfoBO);

        //service
        ProviderInfoBO tServiceInfoBO = new ProviderInfoBO();
        BeanUtils.copyProperties(pRequest.getServiceInfo(), tServiceInfoBO);
        ProductEntity tServiceProductBO = pProviderBO.getProduct();
        tServiceInfoBO.setVer(tServiceProductBO.getVersion());
        tServiceInfoBO.setIp(tServiceProductBO.getIpAddress());
        tServiceInfoBO.setId(tServiceProductBO.getApid());
        tServiceInfoBO.setUid(tServiceProductBO.getUid());
        tServiceRequest.setServiceInfo(tServiceInfoBO);

        tServiceRequest.setRequester(pRequesterBO);
        tServiceRequest.setProvider(pProviderBO);

        tServiceRequest.setBody(pRequest.getBody());

        return tServiceRequest;
    }

}
