package com.digiwin.cross.app.dto;

import com.digiwin.cross.infrastructure.database.entity.StateCodePO;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author clay
 * on 2023/12/4
 */
@Getter
@Setter
public class StateCodeDTO {
    private String code;
    @JsonProperty("description_zh_tw")
    private String descriptionZhTw;
    @JsonProperty("description_zh_cn")
    private String descriptionZhCn;
    @JsonProperty("description_en")
    private String descriptionEn;

    public StateCodeDTO(StateCodePO stateCodePO) {
        this.code = stateCodePO.getCode();
        this.descriptionZhTw = stateCodePO.getCht();
        this.descriptionZhCn = stateCodePO.getChs();
        this.descriptionEn = stateCodePO.getEng();
    }
}
