package com.digiwin.cross.app.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import org.osgi.service.log.LogEntry;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/7/19
 */
@Getter
@Setter
public class SaveDapLogRequest {
    private String req_id;
    @JsonProperty("ptxid")
    private String ptxId;
    private RequestInfo request;
    private ServiceInfo service;
    private List<LogEntry> logs;

    @Getter
    @Setter
    public static class RequestInfo {
        @JsonProperty("ap_name")
        private String apName;
        private String version;
        private String ip;
        private String id;
        private String uid;
        @JsonProperty("ap_user")
        private String apUser;
        private String timestamp;

    }

    @Getter
    @Setter
    public static class ServiceInfo {
        @JsonProperty("ap_name")
        private String apName;
        private String version;
        private String ip;
        private String id;
        private String uid;
        @JsonProperty("tenant_id")
        private String tenantId;
        @JsonProperty("service_name")
        private String serviceName;
    }

    @Getter
    @Setter
    public static class LogEntry {
        @JsonProperty("state_code")
        private String stateCode;
        @JsonProperty("platform_time")
        private Long platformTime;
        @JsonProperty("data_key")
        private String dataKey;
        @JsonProperty("log_display_priority")
        private int logDisplayPriority;
        private String url;
        private Map<String, String> headers;
        private String body;
    }
}
