package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @description: 地端服务响应对象
 * add by songwq 20250715
 * 针对集成中心开放接口 story-view-48716
 * @author: songwq
 * @date: 2025/7/15 14:43
 */
@Getter
@Setter
@NoArgsConstructor
public class GetUnionSrvResponse extends BaseResponse{

    @JsonProperty("data")
    private List<UnionServicePO> service;

    @JsonProperty("code")
    private Integer code;

    @JsonProperty("message")
    private String message;

    @JsonProperty("total")
    private Long total;

    public GetUnionSrvResponse(StateEnum stateEnum, List<UnionServicePO> srvs, Integer code, String message, Long total) {
        super.setState(stateEnum);
        this.service = srvs;
        this.code = code;
        this.message = message;
        this.total = total;
    }
}
