package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * @author clay
 * on 2024/8/6
 */
@Getter
@Setter
public class QueryEaiInfoResponse {
    @JsonProperty("eai_info")
    private EaiDTO eaiDTO;
    @JsonProperty("tenant_id_list")
    private List<String> tenantIdList;

    public Response toResponse() {
        ObjectNode tObjectNode = JsonUtil.createJsonObject();
        return Response.ok(JsonUtil.toJson(this), MediaType.APPLICATION_JSON).build();
    }

}
