/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CleanFullAsyncRequestCmd {
    private static final Log log = LogFactory.getLog(CleanFullAsyncRequestCmd.class);
    private static final String TASK_NAME = "cleanFullAsyncRequest";
    private final IFullAsyncRequestGateway fullAsyncRequestGateway;
    private final ILockGateway lockGateway;

    @Autowired
    public CleanFullAsyncRequestCmd(IFullAsyncRequestGateway fullAsyncRequestGateway, ILockGateway lockGateway) {
        this.fullAsyncRequestGateway = fullAsyncRequestGateway;
        this.lockGateway = lockGateway;
    }

    @Scheduled(cron="0 0 2 * * *")
    public void doTask() {
        boolean isLocked = false;
        isLocked = this.lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 3600);
        if (!isLocked) {
            log.info((Object)"task is running");
            return;
        }
        try {
            log.info((Object)"clean fullAsyncRequest task start");
            this.fullAsyncRequestGateway.deleteOlderThanDays(ApplicationSystemParameter.LOG_RESERVED_DAY.intValue(), 5000);
        }
        catch (Exception e) {
            log.error((Object)"clean fullAsyncRequest err", (Throwable)e);
        }
        finally {
            log.info((Object)"clean fullAsyncRequest task finish");
            if (isLocked) {
                this.lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
            }
        }
    }
}

