/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ILogGateway;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CleanLogCmd {
    private static final Log log = LogFactory.getLog(CleanLogCmd.class);
    public static final String TASK_NAME = "clean_log_task";
    private final ILogGateway logGateway;
    private final ILockGateway lockGateway;

    public CleanLogCmd(ILogGateway logGateway, ILockGateway lockGateway) {
        this.logGateway = logGateway;
        this.lockGateway = lockGateway;
    }

    @Scheduled(cron="0 00 03 ? * *")
    public void doTask() {
        if (!this.lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 120)) {
            log.info((Object)"task is running");
            return;
        }
        try {
            this.logGateway.cleanExpiredLogs();
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
        }
    }
}

