/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.EaiBOConvertor;
import com.digiwin.cross.app.convertor.ProductBOConvertor;
import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.app.dto.EaiProdDTO;
import com.digiwin.cross.app.dto.request.EaiRegisterRequest;
import com.digiwin.cross.app.dto.response.EaiRegisterResponse;
import com.digiwin.cross.domain.bo.EaiBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.EaiTenantEntity;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.UnionEAINotFoundException;
import com.digiwin.cross.domain.gateway.IEaiGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.parameter.SaasParameter;
import com.digiwin.cross.domain.service.IProductService;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class EaiRegisterCmd {
    private static final Log log = LogFactory.getLog(EaiRegisterCmd.class);
    private static final String ACTION_REG = "reg";
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_UNREG = "unreg";
    private final IProductService productService;
    private final IEaiGateway eaiGateway;
    private final IProductQueryGateWay productQueryGateWay;
    private final ISyncMdcGateway syncMdcGateway;
    private EaiDTO espEai;
    private final ILockGateway lockGateway;

    public EaiRegisterCmd(IProductService productService, IEaiGateway eaiGateway, IProductQueryGateWay productQueryGateWay, ISyncMdcGateway syncMdcGateway, ILockGateway lockGateway) {
        this.productService = productService;
        this.eaiGateway = eaiGateway;
        this.productQueryGateWay = productQueryGateWay;
        this.syncMdcGateway = syncMdcGateway;
        this.lockGateway = lockGateway;
        this.espEai = new EaiDTO();
        this.espEai.setIp(ApplicationSystemParameter.SYS_EXT_IP);
        this.espEai.setUid(ApplicationSystemParameter.UNION_SYS_UID);
        this.espEai.setTenant_id(SaasParameter.SAAS_TENANT_ID);
        this.espEai.setGateway_id(SaasParameter.SAAS_GATEWAY_ID);
        this.espEai.setGateway_name(SaasParameter.SAAS_GATEWAY_NAME);
        this.espEai.setRemark(null == ApplicationSystemParameter.UNION_SYS_REMARK ? "" : ApplicationSystemParameter.UNION_SYS_REMARK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EaiRegisterResponse registerEai(EaiRegisterRequest request) throws BaseException {
        this.lockGateway.tryLock(LockNamespaceEnum.REG_EAI, request.getEai().getUid(), 100);
        try {
            EaiEntity eaiEntity = this.eaiGateway.queryEai(request.getEai().getUid());
            if (null != eaiEntity) {
                EaiRegisterResponse eaiRegisterResponse = this.updateEai(request, eaiEntity);
                return eaiRegisterResponse;
            }
            List<EaiProdDTO> repeatProducts = this.findRepeatProducts(request.getProd());
            if (CollectionUtils.isNotEmpty(repeatProducts)) {
                EaiRegisterResponse eaiRegisterResponse = new EaiRegisterResponse(repeatProducts, StateEnum.UNION_PROD_EXIST);
                return eaiRegisterResponse;
            }
            EaiBO eaiBONew = EaiBOConvertor.convertToBO(request);
            List tenants = eaiBONew.getTenants().stream().map(EaiTenantEntity::getTenantId).collect(Collectors.toList());
            List existsEaiTenants = this.eaiGateway.queryOtherEaiTenantByTenantIds(tenants, request.getEai().getUid());
            if (CollectionUtils.isNotEmpty((Collection)existsEaiTenants)) {
                log.error((Object)("tenant is bound:" + JsonUtil.toJson((Object)existsEaiTenants)));
                EaiRegisterResponse eaiRegisterResponse = new EaiRegisterResponse(StateEnum.UNION_TENANT_EXISTS, existsEaiTenants);
                return eaiRegisterResponse;
            }
            this.eaiGateway.addEai(eaiBONew);
            this.syncMdcGateway.syncEai(eaiBONew.getEai(), false);
            EaiRegisterResponse eaiRegisterResponse = new EaiRegisterResponse(ACTION_REG, this.espEai, this.findAllProducts(), StateEnum.REGEAI_REGED);
            return eaiRegisterResponse;
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.REG_EAI, request.getEai().getUid());
        }
    }

    public EaiRegisterResponse unRegisterEai(EaiRegisterRequest request) throws BaseException {
        EaiEntity eaiEntity = this.eaiGateway.queryEai(request.getEai().getUid());
        if (null == eaiEntity) {
            log.info((Object)"Can't find union EAI.");
        } else {
            this.eaiGateway.deleteEai(eaiEntity);
            this.syncMdcGateway.syncEai(eaiEntity, true);
        }
        return new EaiRegisterResponse(ACTION_UNREG, this.espEai, null, StateEnum.REGEAI_DELED);
    }

    public EaiRegisterResponse updateEai(EaiRegisterRequest request, EaiEntity ... eaiEntities) throws BaseException {
        EaiEntity eai;
        boolean isFromReg = eaiEntities.length > 0;
        EaiEntity eaiEntity = eai = isFromReg ? eaiEntities[0] : this.eaiGateway.queryEai(request.getEai().getUid());
        if (null == eai) {
            throw new UnionEAINotFoundException();
        }
        List<EaiProdDTO> repeatProducts = this.findRepeatProducts(request.getProd());
        if (CollectionUtils.isNotEmpty(repeatProducts)) {
            this.eaiGateway.updateEaiStatus(eai.getId(), StateEnum.UNION_PROD_EXIST);
            return new EaiRegisterResponse(repeatProducts, StateEnum.UNION_PROD_EXIST);
        }
        EaiBO eaiBONew = EaiBOConvertor.convertToBO(request);
        List tenants = eaiBONew.getTenants().stream().map(EaiTenantEntity::getTenantId).collect(Collectors.toList());
        List existsEaiTenants = this.eaiGateway.queryOtherEaiTenantByTenantIds(tenants, eai.getUid());
        if (CollectionUtils.isNotEmpty((Collection)existsEaiTenants)) {
            log.error((Object)("tenant is bound:" + JsonUtil.toJson((Object)existsEaiTenants)));
            return new EaiRegisterResponse(StateEnum.UNION_TENANT_EXISTS, existsEaiTenants);
        }
        eaiBONew.getEai().setId(eai.getId());
        this.eaiGateway.updateEai(eaiBONew);
        this.syncMdcGateway.syncEai(eai, false);
        String action = isFromReg ? ACTION_REG : ACTION_UPDATE;
        StateEnum stateEnum = isFromReg ? StateEnum.REGEAI_REGED : StateEnum.REGEAI_UPDED;
        return new EaiRegisterResponse(action, this.espEai, this.findAllProducts(), stateEnum);
    }

    private List<EaiProdDTO> findRepeatProducts(List<EaiProdDTO> products) {
        ArrayList<EaiProdDTO> repeatProducts = new ArrayList<EaiProdDTO>();
        for (EaiProdDTO product : products) {
            boolean existsProduct = this.productService.validExistsProduct(product.getUid(), product.getName(), product.getIp(), product.getId());
            if (!existsProduct) continue;
            repeatProducts.add(product.cloneWithoutSrv());
        }
        return repeatProducts;
    }

    private List<EaiRegisterResponse.EspProduct> findAllProducts() {
        List espProducts = this.productQueryGateWay.queryAllNotClientOnlyProduct();
        return ProductBOConvertor.convertToEaiRegProductDTO(espProducts);
    }
}

