/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.ServiceRequestBOConvertor;
import com.digiwin.cross.app.convertor.ServiceResponseBOConvertor;
import com.digiwin.cross.app.dto.request.InvokeRequest;
import com.digiwin.cross.app.dto.response.InvokeResponse;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.service.IInvokeService;
import com.digiwin.cross.domain.service.validator.ProductValidator;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.state.StateEnum;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class InvokeCmd {
    private ProductValidator productValidator;
    private IInvokeService invokeService;

    public InvokeCmd(ProductValidator productValidator, IInvokeService invokeService) {
        this.productValidator = productValidator;
        this.invokeService = invokeService;
    }

    public InvokeResponse execute(InvokeRequest pRequest) throws Exception {
        RequesterBO tRequesterBO = this.productValidator.validateRequester(pRequest.getHostInfo());
        ProviderBO tProviderBO = this.productValidator.validateProvider(pRequest.getServiceInfo());
        ServiceRequestBO tServiceRequestBO = ServiceRequestBOConvertor.convertToServiceRequestBO(pRequest, tRequesterBO, tProviderBO);
        ServiceResponseBO tServiceResponseBO = this.invokeService.execute(tServiceRequestBO);
        InvokeResponse tInvokeResponse = ServiceResponseBOConvertor.convertToInvokeResponse(tServiceResponseBO, tServiceRequestBO.getCallbackHeaders());
        switch (tServiceRequestBO.getRequestType()) {
            case SYNC: {
                if (BooleanUtils.isNotFalse((Boolean)tServiceResponseBO.getEaiSuccess())) {
                    tInvokeResponse.setState(StateEnum.SYNC_MSG_RETURNED);
                    break;
                }
                tInvokeResponse.setState((StateEnum)StateEnum.STATEENUM_CODE_MAP.get(tServiceResponseBO.getCode()));
                break;
            }
            case FASYNC: {
                if (BooleanUtils.isNotFalse((Boolean)tServiceResponseBO.getEaiSuccess())) {
                    if (tRequesterBO.isAgile()) {
                        tInvokeResponse.setState(StateEnum.FASYNC_MSG_RETURNED);
                        break;
                    }
                    tInvokeResponse.setState(StateEnum.UNION_FASYNC_MSG_RETURNED);
                    break;
                }
                tInvokeResponse.setState((StateEnum)StateEnum.STATEENUM_CODE_MAP.get(tServiceResponseBO.getCode()));
            }
        }
        return tInvokeResponse;
    }
}

