/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.cross.app.dto.EaiMappingDTO;
import com.digiwin.cross.app.dto.request.QueryErrorConnectionRequest;
import com.digiwin.cross.app.dto.response.QueryEaiListResponse;
import com.digiwin.cross.domain.enums.EaiTypeEnum;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryEaiListCmd {
    private static final Log log = LogFactory.getLog(QueryEaiListCmd.class);
    private final UnionEaiMapper unionEaiMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;
    private final DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();
    private int chunkSize = 100;
    private int maxSize = 20;

    @Autowired
    public QueryEaiListCmd(UnionEaiMapper unionEaiMapper, EaiTenantMappingMapper eaiTenantMappingMapper, DWHttpClient dwHttpClient) {
        this.unionEaiMapper = unionEaiMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.dwHttpClient = dwHttpClient;
    }

    public QueryEaiListResponse execute(String token, String tenantId, List<String> versionList, Page page) {
        List eaiTenantMappingPOList = null;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(EaiTenantMappingPO.class);
        if (StringUtil.isNotEmpty((Object)tenantId)) {
            queryWrapper.eq(EaiTenantMappingPO::getTenantId, (Object)tenantId);
            eaiTenantMappingPOList = this.eaiTenantMappingMapper.selectList((Wrapper)queryWrapper);
            ((LambdaQueryWrapper)queryWrapper.or()).eq(EaiTenantMappingPO::getEaiUid, (Object)((EaiTenantMappingPO)eaiTenantMappingPOList.get(0)).getEaiUid());
        }
        eaiTenantMappingPOList = this.eaiTenantMappingMapper.selectList((Wrapper)queryWrapper);
        HashSet<String> eaiIdSet = new HashSet<String>();
        ArrayList<String> tenantIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)eaiTenantMappingPOList)) {
            for (EaiTenantMappingPO eaiTenantMappingPO : eaiTenantMappingPOList) {
                eaiIdSet.add(eaiTenantMappingPO.getEaiUid());
                tenantIdList.add(eaiTenantMappingPO.getTenantId());
            }
        }
        List<String> errorConnectTenantList = this.queryErrorConnect(token, tenantIdList);
        Map<String, String> tenantIdMappingNode = this.callIamGetTenantName(token, tenantIdList);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(UnionEAIPO.class);
        if (CollectionUtils.isNotEmpty(eaiIdSet)) {
            wrapper.in(UnionEAIPO::getUid, eaiIdSet);
        }
        if (CollectionUtils.isNotEmpty(versionList)) {
            wrapper.and(wq -> {
                for (String cond : versionList) {
                    wq.or(sub -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)sub.like(UnionEAIPO::getRemark, (Object)cond);
                    });
                }
            });
        }
        Page unionEAIPOPage = (Page)this.unionEaiMapper.selectPage((IPage)page, (Wrapper)wrapper);
        QueryEaiListResponse response = new QueryEaiListResponse();
        response.setEaiDTOs(this.appendEaiMappingDTO(unionEAIPOPage.getRecords(), eaiTenantMappingPOList, tenantIdMappingNode, errorConnectTenantList));
        response.setCode(200);
        response.setMessage("success");
        response.setTotal(unionEAIPOPage.getTotal());
        return response;
    }

    private List<EaiMappingDTO> appendEaiMappingDTO(List<UnionEAIPO> unionEAIPOList, List<EaiTenantMappingPO> eaiTenantMappingPOList, Map<String, String> tenantIdMappingNode, List<String> errorConnectTenantList) {
        ArrayList<EaiMappingDTO> eaiDTOs = new ArrayList<EaiMappingDTO>();
        for (UnionEAIPO unionEAIPO : unionEAIPOList) {
            EaiMappingDTO eaiMappingDTO = new EaiMappingDTO();
            eaiMappingDTO.setUid(unionEAIPO.getUid());
            String tenantStatus = "1";
            for (EaiTenantMappingPO eaiTenantMappingPO : eaiTenantMappingPOList) {
                if (!unionEAIPO.getUid().equals(eaiTenantMappingPO.getEaiUid())) continue;
                String tid = eaiTenantMappingPO.getTenantId();
                eaiMappingDTO.addTenant(tid, tenantIdMappingNode.get(tid));
                if (!errorConnectTenantList.contains(tid)) continue;
                tenantStatus = "0";
            }
            eaiMappingDTO.setRemark(unionEAIPO.getRemark());
            String remark = unionEAIPO.getRemark();
            if (remark.startsWith(EaiTypeEnum.EAI_TYPE_SHUHUANTONG.getType())) {
                eaiMappingDTO.setType(EaiTypeEnum.EAI_TYPE_SHUHUANTONG.getCode());
            } else if (remark.startsWith(EaiTypeEnum.EAI_TYPE_MILIAN.getType())) {
                eaiMappingDTO.setType(EaiTypeEnum.EAI_TYPE_MILIAN.getCode());
            } else {
                eaiMappingDTO.setType(EaiTypeEnum.EAI_TYPE_CROSS.getCode());
                int i = remark.lastIndexOf("_");
                if (i > 0) {
                    eaiMappingDTO.setRemark(remark.substring(i + 1));
                } else {
                    eaiMappingDTO.setRemark(EaiTypeEnum.EAI_TYPE_CROSS.getType());
                }
            }
            eaiMappingDTO.setIp(unionEAIPO.getIpAddress());
            eaiMappingDTO.setGateway_id(unionEAIPO.getGatewayId());
            eaiMappingDTO.setGateway_name(unionEAIPO.getGatewayName());
            eaiMappingDTO.setBuildTime(unionEAIPO.getBuildTime());
            eaiMappingDTO.setLastUpdateTime(unionEAIPO.getLastUpdateTime());
            eaiMappingDTO.setId(unionEAIPO.getId());
            eaiMappingDTO.setStatus(tenantStatus);
            eaiDTOs.add(eaiMappingDTO);
        }
        return eaiDTOs;
    }

    private Map<String, String> callIamGetTenantName(String token, List<String> tIdList) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        String reqJsonStr = null;
        List<List<String>> tenantIdLists = this.splitList(tIdList, this.chunkSize, this.maxSize);
        for (List<String> tenantIdList : tenantIdLists) {
            try {
                HttpPost tHttpPost = new HttpPost(ApplicationSystemParameter.SDK_IAM + "/api/iam/v2/tenant/simples");
                reqJsonStr = JsonUtil.toJson(tenantIdList);
                StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
                tEntity.setContentEncoding("UTF-8");
                tEntity.setContentType("application/json");
                tHttpPost.setEntity((HttpEntity)tEntity);
                tHttpPost.setHeader("digi-middleware-auth-app", ApplicationSystemParameter.APPTOKEN);
                tHttpPost.setHeader("digi-middleware-auth-user", token);
                String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tHttpPost, String.class, new DWRequestOption(false));
                JsonNode resJson = this.mapper.readTree(tResponse);
                for (JsonNode iamJson : resJson) {
                    resMap.put(iamJson.get("id").asText(), iamJson.get("name").asText());
                }
            }
            catch (DWHttpFailedException dwHttpFailedException) {
                log.error((Object)MessageFormat.format("\u8c03\u7528iam\u5931\u6557; request message body: {0};HTTP\u72c0\u614b\u78bc: {1}; MDC\u56de\u61c9\u7684\u8a0a\u606f: {2}", reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
            }
            catch (Exception e) {
                log.error((Object)("call iam err, tenantIdList =" + reqJsonStr), (Throwable)e);
            }
        }
        return resMap;
    }

    private List<List<String>> splitList(List<String> originalList, int chunkSize, int maxSize) {
        ArrayList<List<String>> chunks = new ArrayList<List<String>>();
        for (int i = 0; i < originalList.size(); i += chunkSize) {
            int maxNum = chunkSize * maxSize;
            if (i > maxNum) {
                log.info((Object)MessageFormat.format("The list of tenants to be queried is too large. Currently, only {0} tenants can be queried", String.valueOf(maxNum)));
                break;
            }
            int end = Math.min(originalList.size(), i + chunkSize);
            chunks.add(new ArrayList<String>(originalList.subList(i, end)));
        }
        return chunks;
    }

    private List<String> queryErrorConnect(String token, List<String> tenantIds) {
        ArrayList<String> errTenantIdList = new ArrayList<String>();
        String reqJsonStr = null;
        List<List<String>> tenantIdLists = this.splitList(tenantIds, this.chunkSize, this.maxSize);
        for (List<String> tenantIdList : tenantIdLists) {
            try {
                HttpPost tHttpPost = new HttpPost(ApplicationSystemParameter.MON_URL + "/restful/standard/esp_mon/tool/config/connect/queryError");
                reqJsonStr = JsonUtil.toJson((Object)new QueryErrorConnectionRequest(tenantIdList));
                StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
                tEntity.setContentEncoding("UTF-8");
                tEntity.setContentType("application/json");
                tHttpPost.setEntity((HttpEntity)tEntity);
                tHttpPost.setHeader("digi-middleware-auth-app", ApplicationSystemParameter.APPTOKEN);
                tHttpPost.setHeader("digi-middleware-auth-user", token);
                String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tHttpPost, String.class, new DWRequestOption(false));
                JsonNode resJson = this.mapper.readTree(tResponse).get("response");
                Iterator resJsonIt = resJson.iterator();
                while (resJsonIt.hasNext()) {
                    errTenantIdList.add(((JsonNode)resJsonIt.next()).get("eai_tenantid").asText());
                }
            }
            catch (Exception e) {
                log.error((Object)("call espmoin err, tenantIdList =" + reqJsonStr), (Throwable)e);
            }
        }
        return errTenantIdList;
    }
}

