/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.cross.app.convertor.ProductBOConvertor;
import com.digiwin.cross.app.dto.request.GetProdRequest;
import com.digiwin.cross.app.dto.response.GetProdListResponse;
import com.digiwin.cross.app.dto.response.GetProdResponse;
import com.digiwin.cross.app.dto.response.GetSrvResponse;
import com.digiwin.cross.app.dto.response.GetUnionProdListResponse;
import com.digiwin.cross.app.dto.response.GetUnionSrvResponse;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.exception.AmbiguousProductException;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.ProductNotFoundException;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.domain.gateway.IServiceQueryGateway;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class RegInfoQueryCmd {
    private final IProductQueryGateWay productQueryGateWay;
    private final IServiceQueryGateway serviceQueryGateway;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;
    private final UnionEaiMapper unionEaiMapper;

    public RegInfoQueryCmd(IProductQueryGateWay productQueryGateWay, IServiceQueryGateway serviceQueryGateway, EaiTenantMappingMapper eaiTenantMappingMapper, UnionEaiMapper unionEaiMapper) {
        this.productQueryGateWay = productQueryGateWay;
        this.serviceQueryGateway = serviceQueryGateway;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.unionEaiMapper = unionEaiMapper;
    }

    public GetProdListResponse getAllProd() {
        List productBOs = this.productQueryGateWay.queryAllProduct();
        return new GetProdListResponse(StateEnum.INFO_PRODLIST, ProductBOConvertor.convertToProductDto(productBOs));
    }

    public GetUnionProdListResponse getUnionProdList(Long eaiId, String tenantId) {
        if (StringUtil.isNotEmpty((Object)tenantId)) {
            EaiTenantMappingPO eaiTenantMappingPO = (EaiTenantMappingPO)this.eaiTenantMappingMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getTenantId, (Object)tenantId));
            UnionEAIPO unionEAIPO = null;
            if (null != eaiTenantMappingPO && StringUtil.isNotEmpty((Object)eaiTenantMappingPO.getEaiUid())) {
                unionEAIPO = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)eaiTenantMappingPO.getEaiUid()));
            }
            if (null != unionEAIPO && null != unionEAIPO.getId()) {
                eaiId = unionEAIPO.getId();
            }
        }
        List productBOs = this.productQueryGateWay.queryUnionProduct(eaiId);
        return new GetUnionProdListResponse(StateEnum.INFO_PRODLIST, ProductBOConvertor.convertToUnionProductDto(productBOs));
    }

    public GetProdResponse getProd(GetProdRequest request) {
        ProductEntity condition = ProductBOConvertor.convertToProductBO(request);
        List productBOs = this.productQueryGateWay.queryProductByCondition(condition);
        return new GetProdResponse(StateEnum.INFO_PROD, ProductBOConvertor.convertToGetProdResInfo(productBOs));
    }

    public GetSrvResponse getSrv(GetProdRequest request) throws BaseException {
        ProductEntity condition = ProductBOConvertor.convertToProductBO(request);
        List productBOs = this.productQueryGateWay.queryProductByCondition(condition);
        if (CollectionUtils.isEmpty((Collection)productBOs)) {
            throw new ProductNotFoundException();
        }
        if (productBOs.size() > 1) {
            throw new AmbiguousProductException();
        }
        List srvs = this.serviceQueryGateway.getSrvByProdId(((ProductEntity)productBOs.get(0)).getId());
        return new GetSrvResponse(StateEnum.INFO_SRVLIST, srvs);
    }

    public GetUnionSrvResponse getUnionSrvList(Long pid, String name, Page page) throws BaseException {
        Page srvs = this.serviceQueryGateway.getUnionServiceLis(pid, name, page);
        return new GetUnionSrvResponse(StateEnum.INFO_SRVLIST, srvs.getRecords(), 200, "success", srvs.getTotal());
    }
}

