/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SyncMdcAllCmd {
    private static final Log log = LogFactory.getLog(SyncMdcAllCmd.class);
    public static final String TASK_NAME = "sync_mdc_task";
    private final ILockGateway lockGateway;
    private final ISyncMdcGateway syncMdcGateway;
    private final EspRedisService espRedisService;

    public SyncMdcAllCmd(ILockGateway lockGateway, ISyncMdcGateway syncMdcGateway, EspRedisService espRedisService) {
        this.lockGateway = lockGateway;
        this.syncMdcGateway = syncMdcGateway;
        this.espRedisService = espRedisService;
    }

    @Scheduled(fixedDelay=300000L)
    public void doTask() {
        if (!this.lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 120)) {
            log.info((Object)"task is running");
            return;
        }
        try {
            if (this.espRedisService.remove(CacheKeyEnum.ESP_MDC_ERR_FLAG, "ERROR_FLAG") != null) {
                log.warn((Object)"\u6709\u540c\u6b65MDC\u5931\u8d25\uff0c\u5f00\u59cb\u8865\u507f");
                this.syncMdcGateway.syncAllProduct();
            } else {
                log.warn((Object)"\u65e0\u540c\u6b65MDC\u5931\u8d25");
            }
        }
        finally {
            this.lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
        }
    }
}

