/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.request.SaveDapLogRequest;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.GZipUtil;
import com.digiwin.cross.domain.utils.LogUtil;
import com.digiwin.cross.domain.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SaveDapLogConvertor {
    public static List<LogBO> convertToLogBOList(SaveDapLogRequest request) throws IOException {
        SaveDapLogRequest.RequestInfo tRequest = request.getRequest();
        RequesterInfoBO tRequesterInfo = new RequesterInfoBO();
        tRequesterInfo.setProd(tRequest.getApName());
        tRequesterInfo.setVer(tRequest.getVersion());
        tRequesterInfo.setIp(tRequest.getIp());
        tRequesterInfo.setId(tRequest.getId());
        tRequesterInfo.setUid(tRequest.getUid());
        tRequesterInfo.setAcct(tRequest.getApUser());
        tRequesterInfo.setTimestamp(tRequest.getTimestamp());
        SaveDapLogRequest.ServiceInfo tService = request.getService();
        ProviderInfoBO tProviderInfo = new ProviderInfoBO();
        tProviderInfo.setProd(tService.getApName());
        tProviderInfo.setVer(tService.getVersion());
        tProviderInfo.setIp(tService.getIp());
        tProviderInfo.setId(tService.getId());
        tProviderInfo.setUid(tService.getUid());
        tProviderInfo.setName(tService.getServiceName());
        tProviderInfo.setTenantId(tService.getTenantId());
        ArrayList<LogBO> tLogBOList = new ArrayList<LogBO>();
        for (SaveDapLogRequest.LogEntry logEntry : request.getLogs()) {
            LogBO tLogBO = new LogBO();
            tLogBO.setReqId(request.getReq_id());
            tLogBO.setRequesterBO(tRequesterInfo);
            tLogBO.setProviderBO(tProviderInfo);
            tLogBO.setStateEnum((StateEnum)StateEnum.STATEENUM_CODE_MAP.get(logEntry.getStateCode()));
            tLogBO.setLogDisplayPriority(Integer.valueOf(logEntry.getLogDisplayPriority()));
            tLogBO.setReqDataKey(logEntry.getDataKey());
            tLogBO.setOperation("dapLogs");
            tLogBO.setMsgType(LogBO.MessageFormat.JSON);
            String tHttpLine = null;
            if (StringUtils.isNotBlank((CharSequence)logEntry.getUrl())) {
                tHttpLine = "POST " + logEntry.getUrl();
            }
            String tBody = "";
            if (StringUtils.isNotBlank((CharSequence)logEntry.getBody())) {
                tBody = GZipUtil.decompress((String)logEntry.getBody());
            }
            tLogBO.setMessage(LogUtil.convertRestLogMessage((String)tHttpLine, logEntry.getHeaders(), (String)tBody, (String)request.getPtxId()));
            tLogBO.setMessageSize(StringUtil.calcStringSize((String)tBody));
            Calendar tPlatformTime = Calendar.getInstance();
            tPlatformTime.setTimeInMillis(logEntry.getPlatformTime());
            tLogBO.setPlatformTime(tPlatformTime);
            tLogBO.setPinpointId(request.getPtxId());
            tLogBOList.add(tLogBO);
        }
        return tLogBOList;
    }
}

