/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.athena.esp.sdk.enums.TenantInfoEnum;
import com.digiwin.athena.esp.sdk.util.TenantInfoUtil;
import com.digiwin.cross.app.dto.Eocmap;
import com.digiwin.cross.app.dto.request.InvokeRequest;
import com.digiwin.cross.app.exception.LocalEaiInvokeTenantIdNotFoundException;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.IFilterHeaderService;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.utils.FilterHeaderUtil;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceRequestBOConvertor
implements ApplicationContextAware {
    private static IFilterHeaderService filterHeaderService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        filterHeaderService = (IFilterHeaderService)applicationContext.getBean(IFilterHeaderService.class);
    }

    public static ServiceRequestBO convertToServiceRequestBO(InvokeRequest pRequest, RequesterBO pRequesterBO, ProviderBO pProviderBO) throws BaseException {
        ServiceRequestBO tServiceRequest = new ServiceRequestBO();
        tServiceRequest.setReqId(pRequest.getReqId());
        tServiceRequest.setDispatchId(pRequest.getDispatchId());
        tServiceRequest.setPathParam(pRequest.getPathParam());
        tServiceRequest.setQueryParams(pRequest.getQueryParam());
        Map tCallbackHeaders = FilterHeaderUtil.callbackHeaders(pRequest.getHeaders());
        tServiceRequest.setCallbackHeaders(tCallbackHeaders);
        Map tPassHeaders = FilterHeaderUtil.passHeaders(pRequest.getHeaders());
        tPassHeaders = FilterHeaderUtil.filterBlockHeaders((Map)tPassHeaders, (ProductType)pProviderBO.getProductType());
        Eocmap tEocmap = new Eocmap();
        tPassHeaders.forEach((headerName, headerValue) -> {
            switch (headerName) {
                case "digi-reqid": 
                case "digi-host": 
                case "digi-service": 
                case "digi-key": 
                case "dispatchid": {
                    break;
                }
                case "digi-type": {
                    RequestType tRequestType = (RequestType)EnumUtils.getEnum(RequestType.class, (String)headerValue.toUpperCase());
                    tServiceRequest.setRequestType(tRequestType);
                    break;
                }
                case "digi-datakey": {
                    tServiceRequest.setDataKey(headerValue);
                    break;
                }
                case "digi-ommap": {
                    if (StringUtils.isBlank((CharSequence)pRequest.getServiceInfo().getTenantId())) {
                        Map tMap = null;
                        tEocmap.setExist(true);
                        try {
                            tMap = TenantInfoUtil.getTenantIdAndToken((String)pRequest.getHostInfo().getEaiUid(), (String)pRequest.getHostInfo().getUid(), (String)headerValue);
                            if (tMap.get(TenantInfoEnum.TENANT_ID.toString()) != null) {
                                tEocmap.setTenantId((String)tMap.get(TenantInfoEnum.TENANT_ID.toString()));
                            }
                            if (tMap.get(TenantInfoEnum.USER_TOKEN.toString()) != null) {
                                tEocmap.setToken((String)tMap.get(TenantInfoEnum.USER_TOKEN.toString()));
                            }
                            String eocMapString = TenantInfoUtil.getEocMap((String)((String)tMap.get(TenantInfoEnum.TENANT_ID.toString())), (String)pRequest.getHostInfo().getProd(), (String)headerValue);
                            tEocmap.setEocmap(eocMapString);
                        }
                        catch (Exception e) {
                            tEocmap.setException(new LocalEaiInvokeTenantIdNotFoundException(e));
                        }
                    }
                    tServiceRequest.getDigiHeaders().put(headerName, headerValue);
                    break;
                }
                default: {
                    tServiceRequest.getDigiHeaders().put(headerName, headerValue);
                }
            }
        });
        if (tEocmap.isExist()) {
            if (tEocmap.getException() != null) {
                throw tEocmap.getException();
            }
            if (tEocmap.getTenantId() != null) {
                pRequest.getServiceInfo().setTenantId(tEocmap.getTenantId());
                tServiceRequest.getDigiHeaders().put("routerKey", tEocmap.getTenantId());
            }
            if (tEocmap.getToken() != null) {
                tServiceRequest.getDigiHeaders().put("token", tEocmap.getToken());
            }
            if (tEocmap.getEocmap() != null) {
                tServiceRequest.getDigiHeaders().put("digi-eocmap", tEocmap.getEocmap());
            }
        }
        RequesterInfoBO tHostInfoBO = new RequesterInfoBO();
        BeanUtils.copyProperties((Object)pRequest.getHostInfo(), (Object)tHostInfoBO);
        ProductEntity tHostProductBO = pRequesterBO.getProduct();
        if (tHostProductBO != null) {
            tHostInfoBO.setVer(tHostProductBO.getVersion());
            tHostInfoBO.setIp(Objects.toString(tHostProductBO.getIpAddress(), ""));
            tHostInfoBO.setId(tHostProductBO.getApid());
            tHostInfoBO.setUid(tHostProductBO.getUid());
        }
        if (pProviderBO.getProductType() == ProductType.STANDARD) {
            tHostInfoBO.setEaiUid(ApplicationSystemParameter.UNION_SYS_UID);
        }
        tServiceRequest.setHostInfo(tHostInfoBO);
        ProviderInfoBO tServiceInfoBO = new ProviderInfoBO();
        BeanUtils.copyProperties((Object)pRequest.getServiceInfo(), (Object)tServiceInfoBO);
        ProductEntity tServiceProductBO = pProviderBO.getProduct();
        tServiceInfoBO.setVer(tServiceProductBO.getVersion());
        tServiceInfoBO.setIp(tServiceProductBO.getIpAddress());
        tServiceInfoBO.setId(tServiceProductBO.getApid());
        tServiceInfoBO.setUid(tServiceProductBO.getUid());
        tServiceRequest.setServiceInfo(tServiceInfoBO);
        tServiceRequest.setRequester(pRequesterBO);
        tServiceRequest.setProvider(pProviderBO);
        tServiceRequest.setBody(pRequest.getBody());
        return tServiceRequest;
    }
}

