/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.convertor;

import com.digiwin.cross.app.dto.StateCodeSolutionDTO;
import com.digiwin.cross.domain.bo.entity.StateCodeSolutionEntity;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StateCodeSolutionConverter {
    public static StateCodeSolutionDTO convertToStateCodeSolutionDTO(StateCodeSolutionEntity stateCodeSolutionEntity, String reqAp, String resAp, String service) {
        StateCodeSolutionDTO tStateCodeSolutionDTO = new StateCodeSolutionDTO();
        tStateCodeSolutionDTO.setStateCode(stateCodeSolutionEntity.getStateCode());
        tStateCodeSolutionDTO.setSolutionZhTW(stateCodeSolutionEntity.getSolutionZhTW().stream().map(s -> StateCodeSolutionConverter.replaceSolutionContent(s, reqAp, resAp, service)).collect(Collectors.toList()));
        tStateCodeSolutionDTO.setSolutionZhCN(stateCodeSolutionEntity.getSolutionZhCN().stream().map(s -> StateCodeSolutionConverter.replaceSolutionContent(s, reqAp, resAp, service)).collect(Collectors.toList()));
        tStateCodeSolutionDTO.setSolutionEN(stateCodeSolutionEntity.getSolutionEN().stream().map(s -> StateCodeSolutionConverter.replaceSolutionContent(s, reqAp, resAp, service)).collect(Collectors.toList()));
        return tStateCodeSolutionDTO;
    }

    private static String replaceSolutionContent(String content, String reqAp, String resAp, String serviceName) {
        if (StringUtils.isNotEmpty((CharSequence)reqAp)) {
            String[] tReqAp = reqAp.split("/");
            content = content.replaceAll("\\[\u670d\u52d9\u8acb\u6c42\u65b9\\]", tReqAp[0]);
            content = content.replaceAll("\\[\u670d\u52a1\u8bf7\u6c42\u65b9\\]", tReqAp[0]);
            content = content.replaceAll("\\[service requester\\]", tReqAp[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)resAp)) {
            String[] tResAp = resAp.split("/");
            content = content.replaceAll("\\[\u670d\u52d9\u63d0\u4f9b\u65b9\\]", tResAp[0]);
            content = content.replaceAll("\\[\u670d\u52a1\u63d0\u4f9b\u65b9\\]", tResAp[0]);
            content = content.replaceAll("\\[service provider\\]", tResAp[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            content = content.replaceAll("\\[\u670d\u52d9\u540d\u7a31\\]", serviceName);
            content = content.replaceAll("\\[\u670d\u52a1\u540d\u79f0\\]", serviceName);
            content = content.replaceAll("\\[service name\\]", serviceName);
        }
        return content;
    }
}

