/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.EaiLogDTO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class QueryEaiLogsResponse {
    int code;
    String description;
    List<EaiLogDTO> logs;

    public Response toResponse() {
        ObjectNode tObjectNode = JsonUtil.createJsonObject();
        ObjectNode tExceptionNode = tObjectNode.putObject("execution");
        tExceptionNode.put("code", String.valueOf(this.code));
        tExceptionNode.put("description", StringUtils.defaultString((String)this.description, (String)""));
        tObjectNode.set("logs", JsonUtil.getMAPPER().valueToTree(this.logs));
        return Response.ok((Object)JsonUtil.toJson((Object)tObjectNode), (String)"application/json").build();
    }

    QueryEaiLogsResponse(int code, String description, List<EaiLogDTO> logs) {
        this.code = code;
        this.description = description;
        this.logs = logs;
    }

    public static QueryEaiLogsResponseBuilder builder() {
        return new QueryEaiLogsResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EaiLogDTO> getLogs() {
        return this.logs;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogs(List<EaiLogDTO> logs) {
        this.logs = logs;
    }

    public static class QueryEaiLogsResponseBuilder {
        private int code;
        private String description;
        private List<EaiLogDTO> logs;

        QueryEaiLogsResponseBuilder() {
        }

        public QueryEaiLogsResponseBuilder code(int code) {
            this.code = code;
            return this;
        }

        public QueryEaiLogsResponseBuilder description(String description) {
            this.description = description;
            return this;
        }

        public QueryEaiLogsResponseBuilder logs(List<EaiLogDTO> logs) {
            this.logs = logs;
            return this;
        }

        public QueryEaiLogsResponse build() {
            return new QueryEaiLogsResponse(this.code, this.description, this.logs);
        }

        public String toString() {
            return "QueryEaiLogsResponse.QueryEaiLogsResponseBuilder(code=" + this.code + ", description=" + this.description + ", logs=" + this.logs + ")";
        }
    }
}

