package com.digiwin.cross.domain.bo;

import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/20
 */
@Getter
@Setter
public class ServiceRequestBO {
    private String reqId;
    private String dispatchId;
    private String pathParam;
    private String queryParams;

    private RequestType requestType;
    private String dataKey;
    private Map<String, String> digiHeaders = new HashMap<>();
    private Map<String, String> callbackHeaders = new HashMap<>();

    private RequesterInfoBO hostInfo;
    private ProviderInfoBO serviceInfo;

    private RequesterBO requester;
    private ProviderBO provider;

    private String body;

    // 链路ID
    private String pinpointId;

}
