package com.digiwin.cross.domain.convertor;

import com.digiwin.cross.domain.bo.CallbackTimeoutProductBO;
import com.digiwin.cross.domain.bo.CallbackTimeoutDataBO;
import com.digiwin.cross.domain.bo.entity.CallbackTimeoutEntity;
import com.digiwin.cross.domain.enums.CallbackTimeoutTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author clay
 * on 2024/9/5
 */
public class CallbackTimeoutEntityConvertor {
    public static List<CallbackTimeoutDataBO> convertToCallbackTimeoutDataBOList(CallbackTimeoutEntity entity) {
        List<CallbackTimeoutDataBO> list = new ArrayList<>();

        CallbackTimeoutProductBO productBO = entity.getCallbackTImeoutProductBO();

        String productName = productBO.getProductName();
        String productUid = productBO.getProductUid();
        String tenantId = productBO.getTenantId();
        Integer timeout = productBO.getTimeout();


        CallbackTimeoutDataBO productDataBO = new CallbackTimeoutDataBO();
        productDataBO.setType(CallbackTimeoutTypeEnum.PRODUCT);
        productDataBO.setProductName(productName);
        productDataBO.setProductUid(productUid);
        productDataBO.setTenantId(tenantId);
        productDataBO.setTimeout(timeout);

        list.add(productDataBO);

        if (CollectionUtils.isNotEmpty(entity.getCallbackTimeoutServiceBOList())) {
            entity.getCallbackTimeoutServiceBOList().forEach(callbackTimeoutServiceBO -> {
                CallbackTimeoutDataBO serviceDataBO = new CallbackTimeoutDataBO();
                serviceDataBO.setType(CallbackTimeoutTypeEnum.SERVICE);
                serviceDataBO.setProductName(productName);
                serviceDataBO.setProductUid(productUid);
                serviceDataBO.setTenantId(tenantId);
                serviceDataBO.setServiceName(callbackTimeoutServiceBO.getServiceName());
                serviceDataBO.setTimeout(callbackTimeoutServiceBO.getTimeout());
                list.add(serviceDataBO);
            });
        }
        return list;
    }
}
