package com.digiwin.cross.domain.parameter;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/1
 */

@Component
@PropertiesFile("systemparam.properties")
public class ApplicationSystemParameter extends PropertiesParameter implements InitializingBean {

    @PropertiesKey("sdk_esp")
    public static String SDK_ESP;
    @PropertiesKey("sdk_thememap")
    public static String SDK_THEMEMAP;
    @PropertiesKey("sdk_iam")
    public static String SDK_IAM;
    @PropertiesKey("sdk_eoc")
    public static String SDK_EOC;
    //訊息大小限制
    @PropertiesKey("service.request.msg.size")
    public static Double SERVICE_REQUEST_MSG_SIZE;

    //預設狀態碼語系
    @PropertiesKey("message.language")
    public static String MESSAGE_LANGUAGE;

    @PropertiesKey("apreg.timezone")
    public static String APREG_DEFAULT_TIMEZONE;

    //REDIS相關參數
    @PropertiesKey("spring.redis.enable")
    public static Boolean REDIS_ENABLE=true;
    @PropertiesKey("spring.redis.host")
    public static String REDIS_HOST;
    @PropertiesKey("spring.redis.port")
    public static String REDIS_PORT;
    @PropertiesKey("spring.redis.database")
    public static Integer REDIS_DATABASE;
    @PropertiesKey(value = "spring.redis.password")
    public static String REDIS_PASSWORD;
    @PropertiesKey("spring.redis.timeout")
    public static Integer REDIS_TIMEOUT;
    @PropertiesKey("spring.redis.pool.size")
    public static Integer REDIS_POOL_SIZE;

    @PropertiesKey("system.uid")
    public static String UNION_SYS_UID;

    @PropertiesKey("system.remark")
    public static String UNION_SYS_REMARK;

    @PropertiesKey("system.ext.ip")
    public static String SYS_EXT_IP;

    @PropertiesKey("mdc.url")
    public static String MDC_URL;

    @PropertiesKey("mon.url")
    public static String MON_URL;

    @PropertiesKey("espmdc.url")
    public static String ESP_MDC_URL;

    @PropertiesKey("espdp.url")
    public static String ESPDP_URL;

    @PropertiesKey("service.engine.srv.timeout")
    public static Long SERVICE_ENGINE_SRV_TIMEOUT;
    @PropertiesKey("service.retrytimes")
    public static Integer SRV_RETRY_TIMES;
    @PropertiesKey("service.retryinterval")
    public static Long SRV_RETRY_INTERVAL;

    @PropertiesKey("union.service.engine.srv.timeout")
    public static Long UNION_SERVICE_ENGINE_SRV_TIMEOUT;
    @PropertiesKey("union.service.retrytimes")
    public static Long UNION_SRV_RETRY_TIMES;
    @PropertiesKey("union.service.retryinterval")
    public static Long UNION_SRV_RETRY_INTERVAL;

    @PropertiesKey("message.security.check")
    public static String MSG_SECURITY_CHECK;

    @PropertiesKey("log.clean.date.lastreserved")
    public static Integer LOG_RESERVED_DAY;

    /**
     * 日志配置
     */
    @PropertiesKey("log.config")
    public static String LOG_CONFIG;

    /**
     * mmc url
     */
    @PropertiesKey("mmc.url")
    public static String MMC_URL;

    /**
     * mmc日志存储路径
     */
    @PropertiesKey("mmc.create.log.path")
    public static String MMC_CREATE_LOG_PATH;

    /**
     * mmc日志存储路径
     */
    @PropertiesKey("appToken")
    public static String APPTOKEN;

    @PropertiesKey("app_id")
    public static String APP_ID;

    @PropertiesKey("app_token")
    public static String APP_TOKEN;

    /**
     * 设置全异步回调
     */
    @PropertiesKey("full.async.callBack.timeOut")
    public static Integer FULL_ASYNC_CALLBACK_TIMEOUT;


    @PropertiesKey("ignore.duplicate.service.name")
    public static String IGNORE_DUPLICATE_SERVICE_NAME;

    @PropertiesKey("bigResSize")
    public static Integer BIG_RES_SIZE;

    @PropertiesKey("alarm.url")
    public static String ALARM_URL;

    @PropertiesKey("alarm.enable")
    public static Boolean ALARM_ENABLE = true;


    private static Boolean loaded=false;

//    static {
//        loadParameter(ApplicationParameter.class);
//    }

    @Override
    public void afterPropertiesSet() throws Exception {
        load();
    }

    public static void load(){
        if(!loaded){
            loadParameter(ApplicationSystemParameter.class);
            loaded=true;
        }
    }

}
