package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.entity.CallbackTimeoutEntity;
import com.digiwin.cross.domain.convertor.CallbackTimeoutEntityConvertor;
import com.digiwin.cross.domain.gateway.ICallbackTimeoutGateway;
import com.digiwin.cross.domain.service.ICallbackTimeoutService;
import org.springframework.stereotype.Service;

/**
 * @author clay
 * on 2024/9/3
 */
@Service
public class CallbackTimeoutService implements ICallbackTimeoutService {

    private ICallbackTimeoutGateway callbackTimeoutGateway;

    public CallbackTimeoutService(ICallbackTimeoutGateway callbackTimeoutGateway) {
        this.callbackTimeoutGateway = callbackTimeoutGateway;
    }

    @Override
    public void config(CallbackTimeoutEntity callbackTimeoutEntity) {
        callbackTimeoutGateway.saveOrDelete(CallbackTimeoutEntityConvertor.convertToCallbackTimeoutDataBOList(callbackTimeoutEntity));
    }

    @Override
    public CallbackTimeoutEntity query(CallbackTimeoutEntity callbackTimeoutEntity) {
        return callbackTimeoutGateway.find(callbackTimeoutEntity.getCallbackTImeoutProductBO(),callbackTimeoutEntity.getCallbackTimeoutServiceBOList());
    }
}
