package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.service.IFilterHeaderService;
import com.digiwin.cross.domain.utils.SpringContextUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JsonLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/13
 */
@Service
public class FilterHeaderService implements IFilterHeaderService {

    private final ObjectMapper objectMapper = new ObjectMapper();

    private List<String> serviceHeaderList;
    private List<String> callbackHeaderList;
    private List<String> blockAgileHeader;
    private List<String> blockStandardHeader;

    @PostConstruct
    public void redaProperties() throws Exception {
        Properties tProps = new Properties();
//        try (InputStream fileIs = new FileSystemResource("conf/passHeader.properties").getInputStream()) {
//            tProps.load(fileIs);
//        } catch (IOException e) {
//            throw e;
//        }
        ObjectReader tObjectReader = objectMapper.readerFor(new TypeReference<List<String>>() {
        });

        JsonNode tServiceHeaderJsonNode = JsonLoader.fromString(SpringContextUtil.getStringProp("service.header"));
        serviceHeaderList = tObjectReader.readValue(tServiceHeaderJsonNode);

        JsonNode tCallbackHeaderJsonNode = JsonLoader.fromString(SpringContextUtil.getStringProp("callback.header"));
        callbackHeaderList = tObjectReader.readValue(tCallbackHeaderJsonNode);

        JsonNode tBlockAgileHeader = JsonLoader.fromString(SpringContextUtil.getStringProp("block.agile.header"));
        blockAgileHeader = tObjectReader.readValue(tBlockAgileHeader);

        JsonNode tBlockStandardHeader = JsonLoader.fromString(SpringContextUtil.getStringProp("block.standard.header"));
        blockStandardHeader = tObjectReader.readValue(tBlockStandardHeader);
    }

    @Override
    public List<String> getServiceHeaderList() {
        return serviceHeaderList;
    }

    @Override
    public List<String> getCallbackHeaderList() {
        return callbackHeaderList;
    }

    @Override
    public List<String> getBlockAgileHeader() {
        return blockAgileHeader;
    }

    @Override
    public List<String> getBlockStandardHeader() {
        return blockStandardHeader;
    }

}
