package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.*;
import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.convertor.InvokeConvertor;
import com.digiwin.cross.domain.gateway.ICallbackTimeoutGateway;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.IInvokeGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.service.IInvokeService;
import com.digiwin.cross.domain.service.validator.InvokeResponseValidator;
import com.digiwin.cross.domain.utils.InvokeLogUtil;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/20
 */
@CommonsLog
@Service
public class InvokeService implements IInvokeService {

    private final static String SUCCESS_SRV_CODE = "000";

    @Autowired
    private IInvokeGateway invokeGateway;
    @Autowired
    private IFullAsyncRequestGateway fullAsyncRequestGateway;
    @Autowired
    private InvokeResponseValidator responseValidator;
    @Autowired
    private ILockGateway lockGateway;

//    public InvokeService (IInvokeGateway invokeGateway, IFullAsyncRequestGateway fullAsyncRequestGateway, InvokeResponseValidator responseValidator, ILockGateway lockGateway) {
//        this.invokeGateway = invokeGateway;
//        this.fullAsyncRequestGateway = fullAsyncRequestGateway;
//        this.responseValidator = responseValidator;
//        this.lockGateway = lockGateway;
//    }

    @Override
    public ServiceResponseBO execute (ServiceRequestBO pServiceRequestBO) throws Exception {
        String tReqId = pServiceRequestBO.getReqId();
        RequestType tRequestType = pServiceRequestBO.getRequestType();
        ProductType tProductType = pServiceRequestBO.getProvider().getProductType();

        //TODO 服務並行控制

        ResponseBO tResponse;
        RequestBO tRequest = InvokeConvertor.convertToRequestBO(pServiceRequestBO);
        String tCode = null;
        String tSrvCode;

        boolean fasyncLocked = false;
        if (pServiceRequestBO.getRequestType() == RequestType.FASYNC) {
            //鎖定全異步請求，避免callback速度過快
            //150秒原因為 請求最多120秒逾時+30秒的數據庫處理時間
            //FIXME 華為測試區的redis鎖有BUG，無法正常運作，暫時改為用重試取得
//            fasyncLocked = lockGateway.tryLock(LockNamespaceEnum.EAI_FULLASYNC_ASKING, tReqId, 1, 150);
//            if (fasyncLocked) {
//                log.info(String.format("Service asking ReqId: %s is locked", tReqId));
//            } else {
//                log.error(String.format("Service asking ReqId: %s locked failed", tReqId));
//            }
        }
        try {
            //log 0X4
            InvokeLogUtil.providerReq(pServiceRequestBO, tRequest);
            switch (pServiceRequestBO.getProvider().getProductType()) {
                //敏態服務
                case AGILE:
                    //調用敏泰服務
                    tResponse = invokeGateway.callProduct(tRequest);
                    responseValidator.validator(tResponse.getHeaders(), tResponse.getBody());

                    tSrvCode = tResponse.getHeaders().get(HeaderNamesConstant.DIGI_SRVCODE);

                    break;
                //穩態服務
                case STANDARD:
                    //調用穩態服務
                    tResponse = invokeGateway.callEai(tRequest);
                    tCode = tResponse.getHeaders().get(HeaderNamesConstant.DIGI_CODE);
                    tSrvCode = tResponse.getHeaders().get(HeaderNamesConstant.DIGI_SRVCODE);

                    break;
                default:
                    throw new IllegalStateException("Unexpected value: " + pServiceRequestBO.getProvider().getProductType());
            }

            //log 0X5/0X6
            InvokeLogUtil.responseRes(tReqId, tResponse, tCode, SUCCESS_SRV_CODE.equals(tSrvCode), tRequestType, tProductType);

            ServiceResponseBO tServiceResponseBO = InvokeConvertor.convertToServiceResponseBO(tResponse);

            // 全异步新增链路ID
            pServiceRequestBO.setPinpointId(ThreadContext.get("PtxId"));

            if (pServiceRequestBO.getRequestType() == RequestType.FASYNC && SUCCESS_SRV_CODE.equals(tServiceResponseBO.getSrvCode())) {

                FullAsyncRequestBO fullAsyncRequestBO = InvokeConvertor.convertToFullAsyncRequest(pServiceRequestBO);
                fullAsyncRequestGateway.saveFullAsyncRequestInfo(fullAsyncRequestBO);

            }
            return tServiceResponseBO;
        } finally {
            //FIXME 華為測試區的redis鎖有BUG，無法正常運作，暫時改為用重試取得
//            if (fasyncLocked) {
//                //解鎖全異步請求
//                lockGateway.unlock(LockNamespaceEnum.EAI_FULLASYNC_ASKING, tReqId);
//                log.info(String.format("Service asking ReqId: %s is unlocked", tReqId));
//            }
        }

    }
}
