package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.common.BeanNameConstant;
import com.digiwin.cross.domain.gateway.ILogGateway;
import com.digiwin.cross.domain.utils.LogUtil;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/29
 */
@Service
public class LogThreadService {
    private ThreadPoolExecutor logExecutorService;

    private ILogGateway logGateway;

    public LogThreadService(@Qualifier(BeanNameConstant.LOG_HANDLER_THREAD_POOL) ThreadPoolExecutor logExecutorService, ILogGateway logGateway) {
        this.logExecutorService = logExecutorService;
        this.logGateway = logGateway;
    }

    @PostConstruct
    public void init() {
        LogUtil.setDependencies(logExecutorService, logGateway);
    }

}
