package com.digiwin.cross.domain.service.util;

import com.digiwin.cross.domain.service.IFilterHeaderService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/13
 */
@Component
public class PassHeaderServiceUtil implements ApplicationContextAware {

    private static ApplicationContext context;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    private static IFilterHeaderService getPassHeaderService() {
        return context.getBean(IFilterHeaderService.class);
    }

    public static List<String> getServiceHeaderList() {
        return getPassHeaderService().getServiceHeaderList();
    }

    public static List<String> getCallbackHeaderList() {
        return getPassHeaderService().getCallbackHeaderList();
    }

    public static List<String> getBlockAgileHeader() {
        return getPassHeaderService().getBlockAgileHeader();
    }

    public static List<String> getBlockStandardHeader() {
        return getPassHeaderService().getBlockStandardHeader();
    }
}
