package com.digiwin.cross.domain.service.validator;

import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.exception.JsonValidatorException;
import com.digiwin.cross.domain.exception.ServiceResponseRestFormatException;
import com.digiwin.cross.domain.exception.ValidatorException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/29
 */
@Component
public class InvokeResponseValidator extends RestMessageValidator {
    private final String[] requiredHeaderNames = {HeaderNamesConstant.DIGI_SRVCODE};

    private InvokeResponseBodyJsonValidator invokeResponseBodyJsonValidator;

    public InvokeResponseValidator(InvokeResponseBodyJsonValidator invokeResponseBodyJsonValidator) {
        this.invokeResponseBodyJsonValidator = invokeResponseBodyJsonValidator;
    }

    @Override
    protected void validatorHeader(Map<String, String> pHeaders) throws ValidatorException {
        for (String tHeaderName : requiredHeaderNames) {
            //缺少必要Header
            String tHeaderValue = pHeaders.get(tHeaderName);
            if (StringUtils.isBlank(tHeaderValue)) {
                throw new ServiceResponseRestFormatException(String.format("Missing header: %s", tHeaderName), headers, body);
            }
        }
    }

    @Override
    protected void validatorBody(String pBody) throws ValidatorException {
        try {
            invokeResponseBodyJsonValidator.validate(pBody, "body");
        } catch (JsonValidatorException e) {
            throw new ServiceResponseRestFormatException(e.getMessage(), headers, body);
        }
    }
}
